c***********************************************************************
      program xyz2extxyz
c***********************************************************************
c-----------------------------------------------------------------------
c     //   variables
c-----------------------------------------------------------------------

c     //   local variables
      implicit none

      integer :: i, iargc
      integer :: natom
      real(8), dimension(:), allocatable :: x, y, z
      real(8), dimension(3,3) :: box
      character(len=4), dimension(:), allocatable :: species
      character(len=80) :: xyzfile, inpfile, extfile
      character(len=80) :: char
      real(8) :: bohr2ang = 0.529177246

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Program xyz2extxyz'
      write( 6, '(a)' )

      if ( iargc() .ne. 3 ) then

         write( 6, '(a)' ) 'Usage: xyz2extxyz.x $1 $2 $3'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: xyz file '
         write( 6, '(a)' ) '$2: PIMD input file'
         write( 6, '(a)' ) '$3: extxyz file'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Example: xyz2extxyz.x final.xyz ' //
     &                     'input.dat final.extxyz'

         stop

      end if

c-----------------------------------------------------------------------
c     //   read arguments
c-----------------------------------------------------------------------

      call getarg( 1, xyzfile )
      call getarg( 2, inpfile )
      call getarg( 3, extfile )

c-----------------------------------------------------------------------
c     //   number of atoms
c-----------------------------------------------------------------------

      open ( 10, file = trim(xyzfile) )
      read ( 10, * ) natom
      close( 10 )

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

      allocate( species(natom) )
      allocate( x(natom) )
      allocate( y(natom) )
      allocate( z(natom) )

c-----------------------------------------------------------------------
c     //   read coordinates from xyz file
c-----------------------------------------------------------------------

      open ( 10, file = trim(xyzfile) )
      read ( 10, * )
      read ( 10, * )
      do i = 1, natom
         read ( 10, * ) species(i), x(i), y(i), z(i)
      end do
      close( 10 )

c-----------------------------------------------------------------------
c     //   read box info from input file
c-----------------------------------------------------------------------

      open ( 11, file = trim(inpfile) )
      do
         read ( 11, * ) char
         if ( char(1:11) .eq. '<iboundary>' ) then
            read ( 11, * ) char
            read ( 11, * ) box(1,1:3)
            read ( 11, * ) box(2,1:3)
            read ( 11, * ) box(3,1:3)
            if ( char(1:4) .eq. 'BOHR' ) box(:,:) = box(:,:)*bohr2ang
            exit
         end if
      end do
      close( 11 )

c-----------------------------------------------------------------------
c     //   output extxyz file
c-----------------------------------------------------------------------

      open ( 12, file = trim(extfile) )
      write( 12, '(i8)' ) natom
      write( 12, '(a,9f10.4,a,a)' ) 'Lattice="', 
     &    box(1:3,1), box(1:3,2), box(1:3,3),
     &    '" Properties=species:S:1:pos:R:3'
      do i = 1, natom
         write( 12, '(a4,3f10.4)' ) species(i), x(i), y(i), z(i)
      end do
      close( 12 )

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Normal termination of xyz2extxyz.'
      write( 6, '(a)' )

      stop
      end