c***********************************************************************
      program xsf2xyz
c***********************************************************************

c     //   local variables
      implicit none

c     //   atomic coordinates
      real(8), dimension(:), allocatable :: x, y, z

c     //   atomic symbols
      character(len=4), dimension(:), allocatable :: symbol

c     //   atom labels
      integer, dimension(:), allocatable :: atomtype

c     //   xsf files
      character(len=80), dimension(:), allocatable :: filename

c     //   input and output files
      character(len=120) :: dir, ref, xyz, pbc

c     //   characters
      character(len=120) :: char

c     //   constants
      real(8), parameter:: au_energy  = 4.3597482d-18
      real(8), parameter:: au_charge  = 1.60217646d-19

c     //   integers
      integer :: ifile, nfile, i, natom, iargc, ierr, iwarn

c     //   real numbers
      real(8) :: const, potential

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Program xsf2xyz'
      write( 6, '(a)' )

      if ( iargc() .ne. 5 ) then

         write( 6, '(a)' ) 'Usage: xsf2xyz.x $1 $2 $3 $4 $5'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: number of atoms'
         write( 6, '(a)' ) '$2: boundary: F (free) or P (periodic)'
         write( 6, '(a)' ) '$3: input xsf directory'
         write( 6, '(a)' ) '$4: reference xyz file (structure.dat)'
         write( 6, '(a)' ) '$5: output xyz file for SCAN'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Example: xsf2xyz.x 192 P ./structures' //
     &                     ' structure.dat structure.new'
         write( 6, '(a)' )

         stop

      end if

c-----------------------------------------------------------------------
c     //   read values
c-----------------------------------------------------------------------

c     //   number of atoms
      call getarg( 1, char )
      read( char, * ) natom

c     //   boundary condition
      call getarg( 2, pbc )

c     //   directory
      call getarg( 3, dir )

c     //   reference
      call getarg( 4, ref )

c     //   output
      call getarg( 5, xyz )

c-----------------------------------------------------------------------
c     //    unix commands
c-----------------------------------------------------------------------

c     //    look for xsf files
      call system( "ls -1 " // trim(dir) // "/*.xsf > tmp1" )

c     //    count line number
      call system( "wc -l tmp1  > tmp2" )

c-----------------------------------------------------------------------
c     //    number of xsf files
c-----------------------------------------------------------------------

c     //    open temporary file
      open ( 10, file = 'tmp2' )

c     //    read number of xsf files
      read ( 10, * ) nfile

c     //    close temporary file
      close( 10 )

c     //   remove temporary file
      call system( "rm tmp2" )

c-----------------------------------------------------------------------
c     //   print
c-----------------------------------------------------------------------

      write( 6, '(a,i8)' ) 'Number of xsf files:', nfile
      write( 6, '(a)' )

c-----------------------------------------------------------------------
c     //    memory allocation
c-----------------------------------------------------------------------

c     //    xsf files
      allocate( filename(nfile) )

c-----------------------------------------------------------------------
c     //    constant
c-----------------------------------------------------------------------

c     //    eV to hartree
      const = au_charge / au_energy

c-----------------------------------------------------------------------
c     //    list of xsf files
c-----------------------------------------------------------------------

c     //    open temporary file
      open ( 10, file = 'tmp1' )

c     //   loop of xsf files
      do ifile = 1, nfile

c        //   read xsf files
         read ( 10, '(a)' ) filename(ifile)

c     //   loop of xsf files
      end do

c     //   close temporary file
      close( 10 )

c     //   remove temporary file
      call system( "rm tmp1" )

c-----------------------------------------------------------------------
c     //    memory allocation
c-----------------------------------------------------------------------

      allocate( x(natom) )
      allocate( y(natom) )
      allocate( z(natom) )
      allocate( symbol(natom) )
      allocate( atomtype(natom) )

c-----------------------------------------------------------------------
c     //    get the atomtypes from the template file
c-----------------------------------------------------------------------

c     //   open the template file
      open( 10, file=trim(ref) )

c     //   skip the first two lines
      read ( 10, *, iostat=ierr ) char
      read ( 10, *, iostat=ierr ) char

c     //   warning flag
      iwarn = 0

c     //   loop of atoms
      do i = 1, natom

c        //   read atom, coordinates, atomtypes
         read ( 10, *, iostat=ierr )
     &      symbol(i), x(i), y(i), z(i), atomtype(i)

c        //   on read error
         if ( ierr .ne. 0 ) then

c           //   warning flag
            iwarn = 1

c           //   one line back
            backspace( 10 )

c           //   reread atom, coordinates
            read ( 10, *, iostat=ierr )
     &         symbol(i), x(i), y(i), z(i)

c           //   atomtype reset to 1
            atomtype(i) = 1

c        //   on read error
         end if

c     //   loop of atoms
      end do

c     //   close the template file
      close( 10 )

c-----------------------------------------------------------------------
c     //   print warning
c-----------------------------------------------------------------------

      if ( iwarn .ne. 0 ) then
         write( 6, '(a)' ) 'Warning - atomtype reset to 1.'
         write( 6, '(a)' )
      end if

c-----------------------------------------------------------------------
c     //    list of xsf files
c-----------------------------------------------------------------------

c     //   initialize file
      call system( "rm -f " // trim(xyz) )

c     //   loop of files
      do ifile = 1, nfile

c        //   open xsf file
         open ( 10, file = trim(filename(ifile)) )

c        //   potential energy in eV
         read ( 10, * ) char, char, char, char, potential

c        //   eV to hartree
         potential = potential * const

c        //   boundary: periodic
         if ( pbc(1:1) .eq. 'P' ) then

c           //   skip reading lines
            do i = 1, 7
               read ( 10, *, iostat=ierr ) char
            end do

c        //   boundary: free
         else

c           //   skip reading lines
            do i = 1, 1
               read ( 10, *, iostat=ierr ) char
            end do

c        //   boundary
         end if

c        //   read atoms
         do i = 1, natom
            read ( 10, *, iostat=ierr ) symbol(i), x(i), y(i), z(i)
         end do

c        //   close xsf file
         close( 10 )

c        //   open xyz file
         open ( 10, file = trim(xyz), access = 'append' )

c        //   print number of atoms
         write( 10, '(i8)' ) natom

c        //   print length unit, file, potential
         write( 10, '(a,a,e24.16)' )
     &       'ANGSTROM ', trim(filename(ifile)), potential

c        //   print atoms
         do i = 1, natom
            write( 10, '(a4,3f16.8,i4)' )
     &         symbol(i), x(i), y(i), z(i), atomtype(i)
         end do

c        //  close xyz file
         close( 10 )

c     //   loop of files
      end do

c-----------------------------------------------------------------------
c     //   final message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
     &   'To run PIMD with the SCAN method, rename '
     &    // trim(xyz) // ' as structure.dat.'
      write( 6, '(a)' )

      write( 6, '(a)' )
     &   'Normal termination of xsf2xyz.'
      write( 6, '(a)' )

      stop
      end
