c///////////////////////////////////////////////////////////////////////
c
c      Author:          M. Shiga
c      Last updated:    Nov 1, 2017 by M. Shiga
c      Description:     convert tinker input file into xyz
c
c///////////////////////////////////////////////////////////////////////
c***********************************************************************
      program txyz2xyz
c***********************************************************************

c     //  local variables
      implicit none

c     //   characters
      character(len=4) :: symbol

c     //   integers
      integer :: i, j, natom

c     //   atomic coordinates
      real(8) :: x, y, z

c     //   read number of atoms
      read( 5, * ) natom

c     //   write number of atoms
      write( 6, '(i6)' ) natom

c     //   write unit
      write( 6, '(a)' ) 'ANGSTROM'

c     //   loop of atoms
      do i = 1, natom

c        //   read number, symbol, coordinates
         read ( 5, * ) j, symbol, x, y, z

c        //   print to structure.dat
         write( 6, '(a4,3f12.6)' ) symbol, x, y, z

c     //  loop of atoms
      end do

      stop
      end

