c***********************************************************************
      program trj2scan
c***********************************************************************

c     //   reset variables
      implicit none

c     //   number of atoms
      integer :: natom

c     //   number of beads
      integer :: nbead

c     //   error flag
      integer :: ierr

c     //   file units
      integer :: iounit = 10
      integer :: iounit_xyz = 11

c     //   unit conversion factor
      real(8) :: bohr2ang = 0.529177246d0

c     //   atomic coordinate
      real(8), dimension(:,:), allocatable :: x, y, z

c     //   potential energy
      real(8), dimension(:), allocatable :: pot

c     //   file names
      character(len=80) :: trjfile, inpfile, strfile, xyzfile

c     //   atomic species
      character(len=4), dimension(:), allocatable :: species

c     //   atomic kind
      integer, dimension(:), allocatable :: ikind

c     //   integers
      integer ::  i, j, k, icount

c     //   real numbers
      real(8) :: vx, vy, vz, fx, fy, fz, xa, ya, za

c-----------------------------------------------------------------------
c     //   usage
c-----------------------------------------------------------------------

      if ( iargc() .ne. 4 ) then

         write( 6, '(a)' ) 
         write( 6, '(a)' ) 'Program trj2scan'
         write( 6, '(a)' ) 
         write( 6, '(a)' ) 'trj.out to scan input'
         write( 6, '(a)' ) 
         write( 6, '(a)' ) 'Usage: trj2scan.x $1 $2 $3 $4'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: trj.out (position trajectory)'
         write( 6, '(a)' ) '$2: input.dat (beads, box)'
         write( 6, '(a)' ) '$3: structure.dat (atoms, atomic kinds)'
         write( 6, '(a)' ) '$4: output file in xyz format'
         write( 6, '(a)' ) 
         write( 6, '(a)' )
     &      'Example: trj2scan.x trj.out input.dat' //
     &      ' structure.dat scan.xyz'
         write( 6, '(a)' )

         stop

      else

         write( 6, '(a)' ) 
         write( 6, '(a)' ) 'Program trj2scan'
         write( 6, '(a)' ) 

      end if

c-----------------------------------------------------------------------
c     //   read arguments
c-----------------------------------------------------------------------

c     //   trajectory file
      call getarg( 1, trjfile )

c     //   input file
      call getarg( 2, inpfile )

c     //   structure file
      call getarg( 3, strfile )

c     //   xyz file
      call getarg( 4, xyzfile )

c-----------------------------------------------------------------------
c     //   number of atoms
c-----------------------------------------------------------------------

c     //   open file
      open ( iounit, file = trim(strfile) )

c     //   number of atoms
      read ( iounit, *, iostat=ierr ) natom

c     //   close file
      close( iounit )

c     //   output
      write( 6, '(a,i8)' ) 'Number of atoms:', natom

c-----------------------------------------------------------------------
c     //   number of beads
c-----------------------------------------------------------------------

c     /*   file open   */
      open ( iounit, file = trim(inpfile) )

c     /*   search for tag    */
      call search_tag ( '<nbead>', 7, iounit, ierr )

c     /*   number of atomic symbols   */
      read ( iounit, *, iostat=ierr ) nbead

c     /*   file close   */
      close( iounit )

c     //   output
      write( 6, '(a,i8)' ) 'Number of beads:', nbead

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

c     //   coordinates
      allocate( x(natom,nbead) )
      allocate( y(natom,nbead) )
      allocate( z(natom,nbead) )

c     //   potential energy
      allocate( pot(nbead) )

c     //   atomic species
      allocate( species(natom) )

c     //   atomic species
      allocate( ikind(natom) )

c-----------------------------------------------------------------------
c     /*   read atomic symbols                                        */
c-----------------------------------------------------------------------

c     //   open file
      open ( iounit, file = trim(strfile) )

c     //   number of atoms
      read ( iounit, *, iostat=ierr )

c     //   comment line
      read ( iounit, *, iostat=ierr )

c     //   loop of atoms
      do i = 1, natom

c        //   atomic symbol
         read( iounit, *, iostat=ierr ) species(i), vx, vy, vz, ikind(i)

c     //   loop of atoms
      end do

c     //   close file
      close( iounit )

c     //   output
      if ( ierr .ne. 0 ) then
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Error in atom kinds.'
         write( 6, '(a)' )
         stop
      end if

c-----------------------------------------------------------------------
c     //   main loop
c-----------------------------------------------------------------------

c     //   open files
      open ( iounit, file = trim(trjfile) )
      open ( iounit_xyz, file = trim(xyzfile) )

c     //   counter
      icount = 0

c     //   loop
      do

c        //   read structure

         do j = 1, nbead
         do i = 1, natom

            read( iounit, *, iostat=ierr )
     &         k, x(i,j), y(i,j), z(i,j),
     &         vx, vy, vz, fx, fy, fz, pot(j)

            if ( ierr .ne. 0 ) go to 100

         end do
         end do

c        //   counter
         icount = icount + 1

c        //   write structure

         do j = 1, nbead

            write( iounit_xyz, '(i8)' ) natom
            write( iounit_xyz, '(a,f16.8)' ) 'ANGSTROM', pot(j)

            do i = 1, natom

               xa = x(i,j) * bohr2ang
               ya = y(i,j) * bohr2ang
               za = z(i,j) * bohr2ang

               write( iounit_xyz, '(a4,3f12.6,i4)' )
     &            species(i), xa, ya, za, ikind(i)

            end do

         end do

c     //   loop
      end do

  100 continue

c     //   close files
      close( iounit )
      close( iounit_xyz )

c-----------------------------------------------------------------------
c     //   end of program
c-----------------------------------------------------------------------

c     //   output
      write( 6, '(a,i8)' ) 'Number of structures:', icount*nbead

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Normal termination of trj2scan.'
      write( 6, '(a)' )

      stop
      end





c***********************************************************************
      subroutine search_tag ( char_tag, length_tag, iounit, ierr )
c***********************************************************************
c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=80) :: char_line

      character(len=length_tag) :: char_tag

c-----------------------------------------------------------------------
c     /*   do loop start                                              */
c-----------------------------------------------------------------------

      do

c-----------------------------------------------------------------------
c        /*   read a line                                             */
c-----------------------------------------------------------------------

         read (iounit,*,iostat=ierr) char_line

c-----------------------------------------------------------------------
c        /*   return if error is found                                */
c-----------------------------------------------------------------------

         if ( ierr .ne. 0 ) return

c-----------------------------------------------------------------------
c        /*   search for the tag                                      */
c-----------------------------------------------------------------------

         k = index(char_line(1:length_tag),char_tag(1:length_tag))

c-----------------------------------------------------------------------
c        /*   return as soon as we find the tag                       */
c-----------------------------------------------------------------------

         if ( k .ge. 1 ) return

c-----------------------------------------------------------------------
c     /*   do loop end                                                */
c-----------------------------------------------------------------------

      end do

      return
      end

