c***********************************************************************
      program test_bcmd
c***********************************************************************

c     //   initialize
      implicit none

c     //   BCMD kick step interval
      integer :: kickstep_bcmd

c     //   temperature
      real(8) :: temperature

c     //   planck constant
      real(8), parameter :: hbar = 1.d0

c     //   circular constant
      real(8), parameter :: pi = 3.141592653589793d0

c     //   Boltzmann constant
      real(8), parameter :: boltz = 0.316682968d-5

c     //   time constant
      real(8), parameter :: au_time = 0.024188843d-15

c     //   step size
      real(8) :: dt, dt_fs, dt_large, dt_large_fs

c     //   step size
      real(8) :: beta, tau, gamma, omega, s1, s2

c     //   integer
      integer :: icount

c     //   characters
      character(len=80) :: char

c-----------------------------------------------------------------------
c     //   read values
c-----------------------------------------------------------------------

c     //   comments
      if ( iargc() .ne. 2 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program test_bcmd'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Usage: test_bcmd.x $1 $2'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: temperature'
         write( 6, '(a)' ) '$2: MD step size [fs]'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Example:'
         write( 6, '(a)' ) './test_bcmd.x 300 0.25'
         write( 6, '(a)' )
         stop

      else

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program test_bcmd'
         write( 6, '(a)' )

      end if

c     //   temperature
      call getarg( 1, char )
      read( char, * ) temperature

c     //   MD step size
      call getarg( 2, char )
      read( char, * ) dt_fs

c-----------------------------------------------------------------------
c     //   start
c-----------------------------------------------------------------------

      write( 6, '(a)' ) "  kickstep  omega*dt    Dt/tau"

      icount = 0

      do kickstep_bcmd = 1, 1000

c        //   fs to au
         dt = dt_fs / ( au_time * 1.d+15 )
         dt_large = dt * dble(kickstep_bcmd)
         dt_large_fs = dt_fs * dble(kickstep_bcmd)

c        //   beta
         beta = 1.d0 / ( boltz * temperature )

c        //   relaxation time
         tau = beta * hbar

c        //   fictitious friction
         gamma = 2.d0 / dt_large

c        //   harmonic frequency
         omega = sqrt( gamma / tau )

c        //   scale 1
         s1 = omega * dt / pi

c        //   scale 2
         s2 = dt_large / tau

c        //   exit
         if ( ( s1 .gt. 0.1 ) .or. ( s2 .gt. 0.1 ) ) cycle

c        //   counter
         icount = icount + 1

c        //   print
         write( 6, '(i10,2f10.5)' ) kickstep_bcmd, s1, s2

      end do

c     //   print
      if ( icount .eq. 0 ) then
         write( 6, '(a)' )
         write( 6, '(a)' ) "MD step size is too large."
      end if

      write( 6, '(a)' )

      stop
      end

