from rdkit import Chem
from rdkit.Chem import AllChem
from rdkit.Chem import rdDistGeom

# Define the SMILES string of the molecule
smiles = 'C(C1C(C(C(C(O1)OC2C(OC(C(C2O)O)O)CO)O)O)O)O'

# Create an RDKit molecule from the SMILES string
mol = Chem.MolFromSmiles(smiles)
mol = Chem.AddHs(mol)

# Generate the 3D coordinates of the molecule using distance geometry
AllChem.EmbedMolecule(mol, maxAttempts=5000)

# Optimize the 3D coordinates using a force field
AllChem.UFFOptimizeMolecule(mol)

# Get the cartesian coordinates of the atoms in the molecule
positions = mol.GetConformer().GetPositions()

# Print the cartesian coordinates in XYZ format
num_atoms = mol.GetNumAtoms()
print(num_atoms)
print(smiles)
for i in range(num_atoms):
    atom = mol.GetAtomWithIdx(i)
    pos = positions[i]
    print("{:<2} {:>10.4f} {:>10.4f} {:>10.4f}".format(
        atom.GetSymbol(), pos[0], pos[1], pos[2]))