c************************************************************************
      program pimdbcmd
c************************************************************************
c-----------------------------------------------------------------------
c     //   local variables
c-----------------------------------------------------------------------

c     //   initialize
      implicit none

c     //   directory namcs
      character(len=80)  :: dir_pimd, dir_bcmd, dir_out

c     //   character
      character(len=120) :: char

c     //   PIMD exectution command
      character(len=120) :: char_exe

c     //   character
      character(len=3)   :: citer

c     //   file unit
      integer :: iounit = 10

c     //   PIMD number of steps
      integer :: nstep_pimd

c     //   BCMD number of steps
      integer :: nstep_bcmd

c     //   PIMD-BCMD iterations
      integer :: niter

c     //   logicals
      logical :: lexist

c     //   integers
      integer :: iter, iargc, i, istep, ierr

c-----------------------------------------------------------------------
c     //   message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Program pimdbcmd'
      write( 6, '(a)' )

      if ( iargc() .ne. 5 ) then

         write( 6, '(a)' ) 'Usage: pimdbcmd.x $1 $2 $3 $4 $5'
         write( 6, '(a)' )
         write( 6, '(a)' ) '   $1: Number of PIMD-BCMD iterations'
         write( 6, '(a)' ) '   $2: PIMD directory'
         write( 6, '(a)' ) '   $3: BCMD directory'
         write( 6, '(a)' ) '   $4: Output directory'
         write( 6, '(a)' ) '   $5: Execution command of PIMD code'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Example:'
         write( 6, '(a)' )
         write( 6, '(a)' ) '   pimdbcmd.x 10 NVT NVE OUT ' //
     &                     '"mpirun -np -10 pimd.mpi.x" > pimdbcmd.out'
         write( 6, '(a)' )

         stop

      end if

c-----------------------------------------------------------------------
c     //   input arguments
c-----------------------------------------------------------------------

c     //   number of PIMD-BCMD iterations
      call getarg( 1, char )
      read( char, * ) niter

c     //   PIMD directory
      call getarg( 2, dir_pimd )

c     //   BCMD directory
      call getarg( 3, dir_bcmd )

c     //   output directory
      call getarg( 4, dir_out )

c     //   number of PIMD-BCMD iterations
      call getarg( 5, char_exe )

c-----------------------------------------------------------------------
c     //   make output file
c-----------------------------------------------------------------------

      call system( "mkdir -p " // trim(dir_out) )

c-----------------------------------------------------------------------
c     //   main loop start
c-----------------------------------------------------------------------

      do

c-----------------------------------------------------------------------
c        //   check iteration
c-----------------------------------------------------------------------

c        //   starting iteration
         iter = 0

c        //   check existence of output
         do i = 0, niter

c           //   integer to character
            call int_to_char( i, citer )

c           //   output directory
            char = trim(dir_out) // "/" // trim(citer)

c           //   check existence of output
            inquire( file = char, exist=lexist )

c           //   if it exists
            if ( lexist ) cycle

c           //   if it does not exist
            iter = i

c           //   if it does not exist
            exit

c        //   check existence of output
         end do

c        //   termination: too many files
         if ( iter .gt. niter-1 ) exit

c-----------------------------------------------------------------------
c        //   PIMD exectuion
c-----------------------------------------------------------------------

c        //   PIMD: number of steps
         open ( iounit, file = trim(dir_pimd) // '/input.dat' )
         call search_tag( "<nstep>", 7, iounit, ierr )
         read ( iounit, *, iostat=ierr ) nstep_pimd
         close( iounit )

c        //   PIMD: print statement
         write ( 6, '(a,i3)' ) 'START PIMD #', iter

c        //   PIMD: initialize restart files
         call system( "cd " // trim(dir_pimd) // "; " //
     &                "mv geometry.ini geometry.bak; " //
     &                "rm -f *.ini *.out *.xyz; " //
     &                "mv geometry.bak geometry.ini" )

c        //   PIMD: run
         call system( "cd " // trim(dir_pimd) // "; " //
     &                trim(char_exe) //
     &                "; cd .." )

c        //   PIMD: print statement
         write ( 6, '(a,i3)' ) 'END PIMD #', iter

c        //   PIMD: check final step
         open ( iounit, file = trim(dir_pimd) // '/step.ini' )
         read ( iounit, *, iostat=ierr ) istep
         close( iounit )

c        //   PIMD: error check
         if ( ( ierr .ne. 0 ) .or. ( istep .lt. nstep_pimd ) ) stop

c        //   PIMD: copy geometry file
         call system( "cp " // trim(dir_pimd) // "/geometry.ini " //
     &                trim(dir_bcmd) )

c-----------------------------------------------------------------------
c        //   BCMD execution
c-----------------------------------------------------------------------

c        //   BCMD: number of steps
         open ( iounit, file = trim(dir_bcmd) // '/input.dat' )
         call search_tag( "<nstep>", 7, iounit, ierr )
         read ( iounit, *, iostat=ierr ) nstep_bcmd
         close( iounit )

c        //   BCMD: print statement
         write ( 6, '(a,i3)' ) 'START BCMD #', iter

c        //   BCMD: initialize restart files
         call system( "cd " // trim(dir_bcmd) // "; " //
     &                "mv geometry.ini geometry.bak; " //
     &                "rm -f *.ini *.out *.xyz; " //
     &                "mv geometry.bak geometry.ini" )

c        //   BCMD: run
         call system( "cd " // trim(dir_bcmd) // "; " //
     &                trim(char_exe) //
     &                "; cd .." )

c        //   BCMD: print statement
         write ( 6, '(a,i3)' ) 'END BCMD #', iter

c        //   BCMD: check final step
         open ( iounit, file = trim(dir_bcmd) // '/step.ini' )
         read ( iounit, *, iostat=ierr ) istep
         close( iounit )

c        //   BCMD: error check
         if ( ( ierr .ne. 0 ) .or. ( istep .lt. nstep_bcmd ) ) stop

c        //   integer to character
         call int_to_char( iter, citer )

c        //   message
         call system( "echo CREATED " // trim(dir_out) //
     &                '/' // trim(citer) )

c        //   BCMD: make output director
         call system( "mkdir -p " // trim(dir_out) //
     &                '/' // trim(citer) )

c        //   BCMD: copy out file
         call system(
     &      "cp " // trim(dir_bcmd) // "/*.out " //
     &      trim(dir_out) // '/' // trim(citer) )

c        //   BCMD: copy dcd file
         call system(
     &      "cp " // trim(dir_bcmd) // "/*.dcd " //
     &      trim(dir_out) // '/' // trim(citer) )

c-----------------------------------------------------------------------
c     //   main loop end
c-----------------------------------------------------------------------

      end do

c-----------------------------------------------------------------------
c     //   main loop end
c-----------------------------------------------------------------------

c     //   last message
      write( 6, '(a)' )
      write( 6, '(a)' ) "Normal termination."
      write( 6, '(a)' )

      stop
      end





c***********************************************************************
      subroutine int_to_char( num, char_num )
c***********************************************************************

c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      integer :: j, num

      character(len=3) :: char_num

c-----------------------------------------------------------------------
c     /*   integer 7   ->   character '007'                           */
c-----------------------------------------------------------------------

      char_num = '   '

      write( char_num, '(i3)' ) num

      do j = 1, 3
          if ( char_num( j:j ) .eq. ' ' ) char_num( j:j ) = '0'
      end do

      return
      end





c***********************************************************************
      subroutine search_tag ( char_tag, length_tag, iounit, ierr )
c***********************************************************************

c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=80) :: char_line

      character(len=length_tag) :: char_tag

c-----------------------------------------------------------------------
c     /*   do loop start                                              */
c-----------------------------------------------------------------------

      do

c-----------------------------------------------------------------------
c        /*   read a line                                             */
c-----------------------------------------------------------------------

c         read (iounit,'(a80)',iostat=ierr) char_line
         read (iounit,*,iostat=ierr) char_line

c-----------------------------------------------------------------------
c        /*   return if error is found                                */
c-----------------------------------------------------------------------

         if ( ierr .ne. 0 ) return

c-----------------------------------------------------------------------
c        /*   search for the tag                                      */
c-----------------------------------------------------------------------

         k = index(char_line(1:length_tag),char_tag(1:length_tag))

c-----------------------------------------------------------------------
c        /*   return as soon as we find the tag                       */
c-----------------------------------------------------------------------

         if ( k .ge. 1 ) return

c-----------------------------------------------------------------------
c     /*   do loop end                                                */
c-----------------------------------------------------------------------

      end do

      return
      end
