c***********************************************************************
      program outcar2npf
c***********************************************************************
c-----------------------------------------------------------------------
c     //   variables
c-----------------------------------------------------------------------

      implicit none
      integer, parameter :: maxatom = 10000
      integer, parameter :: maxspec = 100
      integer :: ierr, i, j, k, iargc
      integer :: natom = 0
      integer :: nspec = 0
      integer :: natom_spec(maxspec)
      character(len=4), dimension(maxspec) :: spec
      character(len=4), dimension(maxatom) :: species
      real(8) :: box(3,3)
      real(8) :: x(maxatom), y(maxatom), z(maxatom)
      real(8) :: pot
      real(8) :: fx(maxatom), fy(maxatom), fz(maxatom)
      character(len=120) :: car
      character(len=120) :: npf
      character(len=240) :: char
      character(len=120) :: char1,char2,char3,char4,char5,char6,char7
      real(8) :: const_1, const_2, const_3, charge

c     //   constants
      real(8), parameter:: au_energy  = 4.3597482d-18
      real(8), parameter:: au_charge  = 1.60217646d-19
      real(8), parameter:: au_length  = 0.529177249d-10

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Program outcar2npf'
      write( 6, '(a)' )

      if ( iargc() .ne. 3 ) then

         write( 6, '(a)' ) 'Usage: outcar2npf.x $1 $2 $3'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: input file (OUTCAR)'
         write( 6, '(a)' ) '$2: output npf file (input.data)'
         write( 6, '(a)' ) '$3: charge (0.0)'
         write( 6, '(a)' )

         stop

      end if

c-----------------------------------------------------------------------
c     //   read values
c-----------------------------------------------------------------------

c     //   input
      call getarg( 1, car )

c     //   output
      call getarg( 2, npf )

c     //   output
      call getarg( 3, char )
      read( char, * ) charge

c-----------------------------------------------------------------------
c     //   read ions per type
c-----------------------------------------------------------------------

      i = 0

      open ( 10, file = trim(car) )

      do

         read ( 10, *, iostat=ierr ) char1
         if ( ierr .ne. 0 ) exit

         if ( char1(1:6) .eq. 'POTCAR' ) i = i + 1

      end do

      close( 10 )

      nspec = i / 2

      if ( nspec .eq. 0 ) then
         write( 6, '(a)' ) 'Error: Number of species.'
         stop
      else
         write( 6, '(a,8x,i4)' ) 'OK: Number of species.', nspec
      end if

c-----------------------------------------------------------------------
c     //   read species
c-----------------------------------------------------------------------

      i = 0

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read( char, *, iostat=ierr ) char1, char2, char3

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:6) .eq. 'POTCAR' ) then
            i = i + 1
            spec(i) = trim(char3)
         end if

         if ( i .eq. nspec ) exit

      end do

      close( 10 )

      if ( nspec .eq. 0 ) then
         write( 6, '(a)' ) 'Error: Species.'
         stop
      else
         write( 6, '(a,18x,100a4)' ) 'OK: Species = ', spec(1:nspec)
      end if

c-----------------------------------------------------------------------
c     //   read ions per type
c-----------------------------------------------------------------------

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read ( char, *, iostat=ierr ) char1, char2, char3

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:4) .ne. 'ions' ) cycle
         if ( char2(1:3) .ne. 'per'  ) cycle
         if ( char3(1:4) .ne. 'type' ) cycle

         backspace( 10 )

         read ( 10, *, iostat=ierr )
     &      char, char, char, char, natom_spec(1:nspec)

         exit

      end do

      close( 10 )

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error: Atoms per species.'
         stop
      else
         write( 6, '(a,7x,100i4)' )
     &      'OK: Atom per species = ', natom_spec(1:nspec)
      end if

c-----------------------------------------------------------------------
c     //   read number of atoms
c-----------------------------------------------------------------------

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read ( char, *, iostat=ierr ) char1, char2, char3

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:6) .ne. 'number' ) cycle
         if ( char2(1:2) .ne. 'of'     ) cycle
         if ( char3(1:3) .ne. 'dos'    ) cycle

         backspace( 10 )

         read ( 10, *, iostat=ierr )
     &      char, char, char, char, char, char, char, char, char, 
     &      char, char, natom

         exit

      end do

      close( 10 )

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error: Number of atoms.'
         stop
      else
         write( 6, '(a,8x,i4)' ) 'OK: Number of atoms = ', natom
      end if

c-----------------------------------------------------------------------
c     //   read atomic position
c-----------------------------------------------------------------------

      k = 0
      do i = 1, nspec
      do j = 1, natom_spec(i)
         k = k + 1
         species(k) = spec(i)
      end do
      end do

      if ( k .ne. natom ) then
         write( 6, '(a)' ) 'Error: Number of atoms do not match.'
         stop
      else
         write( 6, '(a)' ) 'OK: Number of atoms matched.'
      end if

c-----------------------------------------------------------------------
c     //   read atomic position
c-----------------------------------------------------------------------

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read ( char, *, iostat=ierr )
     &      char1, char2, char3, char4, char5, char6, char7

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:8)  .ne. 'position'    ) cycle
         if ( char2(1:2)  .ne. 'of'          ) cycle
         if ( char3(1:4)  .ne. 'ions'        ) cycle
         if ( char4(1:2)  .ne. 'in'          ) cycle
         if ( char5(1:9)  .ne. 'cartesian'   ) cycle
         if ( char6(1:11) .ne. 'coordinates' ) cycle
         if ( char7(1:7)  .ne. '(Angst)'     ) cycle

         do i = 1, natom
            read ( 10, *, iostat=ierr ) x(i), y(i), z(i)
         end do

         exit

      end do

      close( 10 )

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error: Atomic positions.'
         stop
      else
         write( 6, '(a)' ) 'OK: Atomic positions.'
      end if

c-----------------------------------------------------------------------
c     //   read lattice vectors
c-----------------------------------------------------------------------

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read ( char, *, iostat=ierr ) char1, char2

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:7) .ne. 'Lattice' ) cycle
         if ( char2(1:7) .ne. 'vectors' ) cycle

         read ( 10, '(a)', iostat=ierr )

         read ( 10, '(a)', iostat=ierr ) char
         read ( char(8:54), *, iostat=ierr ) box(1:3,1)
         read ( 10, '(a)', iostat=ierr ) char
         read ( char(8:54), *, iostat=ierr ) box(1:3,2)
         read ( 10, '(a)', iostat=ierr ) char
         read ( char(8:54), *, iostat=ierr ) box(1:3,3)

         exit

      end do

      close( 10 )

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error: Lattice vectors.'
         stop
      else
         write( 6, '(a)' ) 'OK: Lattice vectors ='
         write( 6, '(3f10.4)' ) box(1:3,1)
         write( 6, '(3f10.4)' ) box(1:3,2)
         write( 6, '(3f10.4)' ) box(1:3,3)
      end if

c-----------------------------------------------------------------------
c     //   read forces
c-----------------------------------------------------------------------

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read ( char, *, iostat=ierr ) char1, char2, char3

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:8)  .ne. 'POSITION'    ) cycle
         if ( char2(1:11) .ne. 'TOTAL-FORCE' ) cycle
         if ( char3(1:3)  .ne. '(eV'  ) cycle

         read ( 10, '(a)', iostat=ierr )

         do i = 1, natom
            read ( 10, *, iostat=ierr ) fx(i), fy(i), fz(i)
         end do

         exit

      end do

      close( 10 )

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error: Forces.'
         stop
      else
         write( 6, '(a)' ) 'OK: Forces.'
      end if

c-----------------------------------------------------------------------
c     //   read energy
c-----------------------------------------------------------------------

      open ( 10, file = trim(car) )

      do

         read ( 10, '(a)', iostat=ierr ) char
         read ( char, *, iostat=ierr ) char1, char2, char3

         if ( ierr .ne. 0 ) then
            backspace( 10 )
            read ( 10, *, iostat=ierr )
            if ( ierr .ne. 0 ) exit
         end if

         if ( char1(1:4) .ne. 'free'   ) cycle
         if ( char2(1:6) .ne. 'energy' ) cycle
         if ( char3(1:5) .ne. 'TOTEN'  ) cycle

         read ( 10, '(a)', iostat=ierr )

         read ( 10, *, iostat=ierr ) char, char, char, char, pot

         exit

      end do

      close( 10 )

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error: Energy.'
         stop
      else
         write( 6, '(a)' ) 'OK: Energy.'
      end if

c-----------------------------------------------------------------------
c     //    constant
c-----------------------------------------------------------------------

c     /*   conversion factor   */
      const_1 = au_length * 1.d+10

c     /*   conversion factor   */
      const_2 =  au_charge / au_energy

c     /*   conversion factor   */
      const_3 =  1.d0 / const_2 / const_1

c-----------------------------------------------------------------------
c     //   write n2p2 file
c-----------------------------------------------------------------------

c     //   open npf file
      open ( 11, file = trim(npf) )

c     //   unit conversion
      box(:,:) = box(:,:) / const_1

c     /*   geometry in bohr   */
      x(:) = x(:) / const_1
      y(:) = y(:) / const_1
      z(:) = z(:) / const_1

c     /*   force in hartree per bohr   */
      fx(:) = fx(:) / const_3
      fy(:) = fy(:) / const_3
      fz(:) = fz(:) / const_3

c     /*   write one line   */
      write( 11, '(a)' ) 'begin'
      write( 11, '(a)' ) 'comment'
      write( 11, '(a,3e16.8)' ) 'lattice', box(1:3,1)
      write( 11, '(a,3e16.8)' ) 'lattice', box(1:3,2)
      write( 11, '(a,3e16.8)' ) 'lattice', box(1:3,3)

c     /*   loop of atoms   */
      do i = 1, natom

         write( 11, '(a,3e16.8,2x,a,5e16.8)' )
     &      'atom   ',
     &      x(i), y(i), z(i),
     &      species(i),
     &      0.d0, 0.d0,
     &      fx(i), fy(i), fz(i)

c     /*   loop of atoms   */
      end do

      write( 11, '(a,e24.16)' ) 'energy ', pot
      write( 11, '(a,e24.16)' ) 'charge ', charge
      write( 11, '(a)' ) 'end'

c     //   close npf file
      close( 11 )

c-----------------------------------------------------------------------
c     //   final message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' )
     &   'Normal termination of outcar2npf.'
      write( 6, '(a)' )

      stop
      end
