c***********************************************************************
      program nma2vdos
c***********************************************************************
c-----------------------------------------------------------------------
c     //   local variables
c-----------------------------------------------------------------------

c     //   initialize
      implicit none

c     //   file number
      integer :: iounit = 10

c     //   circular constant
      real(8) :: pi

c     //   speed of light in SI units
      real(8), parameter :: speedlight_SI = 2.99892458d+8

c     //   time in atomic units
      real(8), parameter :: au_time = 0.024188843d-15

c     //   number of frequencies
      integer :: nomega

c     //   number of atoms
      integer :: natom

c     //   frequencies
      real(8), dimension(:), allocatable :: omega

c     //   vibrational density of states
      real(8), dimension(:), allocatable :: vdos

c     //   frequencies
      integer :: n_imag, n_zero, n_real, n_larg

c     //   integers
      integer :: i, j, ierr

c     //   characters
      character(len=80) :: char, infile, outfile

c     //   real numbers
      real(8) :: factor_cminv, domega

cc     //   real numbers
c      real(8) :: dnu_cminv

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      if ( iargc() .ne. 4 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program nma2vdos'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Usage: vdos2vfe.x $1 $2 $3 $4'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: input filename: nma.out'
         write( 6, '(a)' ) '$2: output filename: vdos.out'
         write( 6, '(a)' ) '$3: number of atoms'
         write( 6, '(a)' ) '$4: maximum frequency [/cm]'
         write( 6, '(a)' )

         stop

      else

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program vdos2vfe'
         write( 6, '(a)' )

      end if

c-----------------------------------------------------------------------
c     //   constants
c-----------------------------------------------------------------------

c     //   circular constant
      pi = acos(-1.d0)

c     //   conversion from cminv to hartree
      factor_cminv = 1.d0 / (2*pi*speedlight_SI*au_time*100)

cc     //   unit frequency with cminv
c      dnu_cminv = 1.d0 / (2.d0*pi*factor_cminv)

c-----------------------------------------------------------------------
c     //   read data
c-----------------------------------------------------------------------

c     //   input file
      call getarg( 1, infile )

c     //   output file
      call getarg( 2, outfile )

c     //   number of atoms
      call getarg( 3, char )
      read( char, * ) natom

c     //   number of atoms
      call getarg( 4, char )
      read( char, * ) domega
      nomega = nint(domega)

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

c     //   vibrational density of states
      allocate( vdos(nomega) )

c     //   frequencies
      allocate( omega(3*natom) )

c-----------------------------------------------------------------------
c     //   grep frequencies
c-----------------------------------------------------------------------

      call system( 'grep Frequencies ' // trim(infile) //
     &             ' > nma2vdos.out' )

c-----------------------------------------------------------------------
c     //   read frequencies
c-----------------------------------------------------------------------

c     //   open file
      open ( iounit, file = 'nma2vdos.out' ) 

c     //   loop of lines
      do i = 1, natom*3, 3

c        //   read three frequencies
         read( iounit, *, iostat=ierr )
     &      char, char, omega(i+0), omega(i+1), omega(i+2)

c     //   loop of lines
      end do

c     //   close file
      close( iounit )

c     //   remove intermediate file
      call system( 'rm -f nma2vdos.out' )

c-----------------------------------------------------------------------
c     //   compute density of states
c-----------------------------------------------------------------------

c     //   initialize
      vdos(:) = 0.d0

c     //   initialize
      n_imag = 0
      n_zero = 0
      n_real = 0
      n_larg = 0

c     //   loop of frequencies
      do i = 1, natom*3

c        //   frequency
         j = nint(omega(i))

c        //   check frequency
         if ( j .lt. 0 ) then
            n_imag = n_imag + 1
            cycle
         else if ( j .eq. 0 ) then
            n_zero = n_zero + 1
            cycle
         else if ( j .gt. nomega ) then
            n_larg = n_larg + 1
            cycle
         else
            n_real = n_real + 1
         end if

c        //   count density of states
         vdos(j) = vdos(j) + 1.d0

c     //   loop of frequencies
      end do

c-----------------------------------------------------------------------
c     //  print
c-----------------------------------------------------------------------

c     //   open file
      open ( iounit, file = trim(outfile) ) 

         write( iounit, '(a)' )
     &      '----------------------------'
         write( iounit, '(a)' )
     &      ' freq [cm-1]     I_kubo(sum)'
         write( iounit, '(a)' )
     &      '----------------------------'

c     //   loop of frequencies
      do i = 1, nomega

c        //   frequency and vibrational density of states
         write( iounit, '(f12.1,f16.1)' ) dble(i), vdos(i)

c     //   loop of frequencies
      end do

c     //   close file
      close( iounit )

c-----------------------------------------------------------------------
c     //  print
c-----------------------------------------------------------------------


      write( 6, '(a)' ) 'Frequencies:'

c     //   loop of lines
      do i = 1, natom*3, 12

c        //   print frequencies
         if      ( (i+11) .le. natom*3 ) then
            write( 6, '(12i6)' )
     &         nint(omega(i+0)),  nint(omega(i+1)),  nint(omega(i+2)),
     &         nint(omega(i+3)),  nint(omega(i+4)),  nint(omega(i+5)),
     &         nint(omega(i+6)),  nint(omega(i+7)),  nint(omega(i+8)),
     &         nint(omega(i+9)),  nint(omega(i+10)), nint(omega(i+11))
         else if ( (i+8) .le. natom*3 ) then
            write( 6, '(9i6)' )
     &         nint(omega(i+0)),  nint(omega(i+1)),  nint(omega(i+2)),
     &         nint(omega(i+3)),  nint(omega(i+4)),  nint(omega(i+5)),
     &         nint(omega(i+6)),  nint(omega(i+7)),  nint(omega(i+8))
         else if ( (i+5) .le. natom*3 ) then
            write( 6, '(6i6)' )
     &         nint(omega(i+0)),  nint(omega(i+1)),  nint(omega(i+2)),
     &         nint(omega(i+3)),  nint(omega(i+4)),  nint(omega(i+5))
         else if ( (i+2) .le. natom*3 ) then
            write( 6, '(3i6)' )
     &         nint(omega(i+0)),  nint(omega(i+1)),  nint(omega(i+2))
         end if

c     //   loop of lines
      end do
      write( 6, '(a)' ) 

      write( 6, '(a,i6)' ) 'Modes with imaginary frequency:', n_imag
      write( 6, '(a,i6)' ) 'Modes with zero frequency:     ', n_zero
      write( 6, '(a,i6)' ) 'Modes with real frequency:     ', n_real
      write( 6, '(a,i6)' ) 'Modes with large frequency:    ', n_larg
      write( 6, '(a)' ) 
      write( 6, '(a)' ) 'Output printed to ' // trim(outfile) // '.'
      write( 6, '(a)' ) 
      write( 6, '(a)' ) 'Continue to vdos2vfe for free energies.'
      write( 6, '(a)' ) 
      write( 6, '(a)' ) 'Normal termination of nma2vdos.'
      write( 6, '(a)' ) 

      stop
      end

