c***********************************************************************
      program nma2energy
c***********************************************************************

      implicit none

      integer :: iounit = 10
      integer :: i, j, n, ierr, natom, n356, nimg, nvib, iargc
      character(len=80) :: charline, char
      real(8), dimension(:), allocatable :: eigval

      real(8) :: omega_cminv
      real(8) :: omega_cutoff = 1.d0
      real(8) :: temperature
      real(8) :: ecor_z, ecor_t, ecor_c, ecor, fcor, fcor_cls, ecor_cls

      real(8) :: si_ev = 1.60218e-19
      real(8) :: si_kjmol, si_kcalmol, au_kjmol, au_kcalmol, au_ev
      real(8) :: si_hartree = 4.3597447222071e-18

      real(8), parameter :: speedlight_SI = 2.99892458d+8
      real(8), parameter :: au_time = 0.024188843d-15
      real(8), parameter :: boltz = 0.316682968d-5
      real(8), parameter :: hbar = 1.d0

      real(8) :: factor_cminv, pi, omega, beta

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Program nma2energy'
      write( 6, '(a)' )

      if ( iargc() .ne. 1 ) then

         write( 6, '(a)' ) 'Usage: nma2energy.x $1'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: temperature'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Uses nma.out.'
         write( 6, '(a)' )

         stop

      end if

c-----------------------------------------------------------------------
c     //   constants
c-----------------------------------------------------------------------

      pi = acos(-1.d0)

      factor_cminv = 2.d0 * pi * speedlight_SI * au_time * 100.d0

c-----------------------------------------------------------------------

c     //   1000/Na J = 1 kJ/mol
      si_kjmol   = 1.e3 / 6.02214076e23

c     //   4.184 J = 1 cal
      si_kcalmol = si_kjmol * 4.184e0

c-----------------------------------------------------------------------

      call getarg( 1, char )
      read( char, * ) temperature

c-----------------------------------------------------------------------

      open ( iounit, file='nma.out' )
      i = 0
      do
         read( iounit, *, iostat=ierr ) charline
         if ( ierr .ne. 0 ) exit
         if ( charline(1:11) .eq. 'Frequencies' ) i = i + 3
      end do
      close( iounit )

c-----------------------------------------------------------------------

      n = i
      natom = n / 3
      allocate( eigval(n) )

c-----------------------------------------------------------------------

      open ( iounit, file='nma.out' )
      i = 0
      do
         read( iounit, *, iostat=ierr ) charline
         if ( ierr .ne. 0 ) exit
         if ( charline(1:11) .eq. 'Frequencies' ) then
            backspace( iounit )
            read( iounit, * ) char, char,
     &         eigval(i+1), eigval(i+2), eigval(i+3)
            i = i + 3
         end if
      end do
      close( iounit )

c-----------------------------------------------------------------------

      nimg = 0
      n356 = 0
      nvib = 0

      do i = 1, n
         if ( eigval(i) .lt. -omega_cutoff )     nimg = nimg + 1
         if ( abs(eigval(i)) .le. omega_cutoff ) n356 = n356 + 1
         if ( eigval(i) .gt. +omega_cutoff )     nvib = nvib + 1
      end do

c-----------------------------------------------------------------------

      write( 6, '(a,i8)' )
     &   'Number of atoms:                           ', natom

      write( 6, '(a,i8)' )
     &   'Imaginary frequency modes:                 ', nimg

      write( 6, '(a,i8)' )
     &   'Translational, rotational, frozen modes:   ', n356

      write( 6, '(a,i8)' )
     &   'Real vibrational modes:                    ', nvib

      write( 6, '(a,f8.2)' )
     &   'Temperature:                               ', temperature

c-----------------------------------------------------------------------

c     //   inverse of temperature
      beta = 1.d0 / ( boltz*temperature )

c     //   zero point correction (quantum)
      ecor_z = 0.d0

c     //   thermal excitation correction (quantum)
      ecor_t = 0.d0

c     //   translational and rotational corrections (classical)
      ecor_c = 0.d0

c     //   free energy correction (quantum)
      fcor = 0.d0

c     //   energy correction (classical)
      ecor_cls = 0.d0

c     //   free energy correction (classical)
      fcor_cls = 0.d0

c     //   loop of modes
      do j = 1, 3*natom

c        //   frequency
         omega_cminv = eigval(j)

         if      ( omega_cminv .le. -omega_cutoff ) then

            continue

         else if ( abs(omega_cminv) .le. +omega_cutoff ) then

            ecor_c = ecor_c + 0.5d0 / beta

            fcor = fcor +  0.5d0 / beta

            ecor_cls = ecor_cls + 0.5d0 / beta

            fcor_cls = fcor_cls + 0.5d0 / beta

         else

            omega = omega_cminv * factor_cminv

            ecor_z = ecor_z + 0.5d0*hbar*omega

            ecor_t = ecor_t + 0.5d0*hbar*omega
     &             + hbar*omega * exp(-beta*hbar*omega)
     &             / (1.d0 - exp(-beta*hbar*omega))

            fcor = fcor + 0.5d0*hbar*omega
     &           + 1.d0 / beta * log ( 1.d0 - exp(-beta*hbar*omega) )

            ecor_cls = ecor_cls + 1.d0 / beta

            fcor_cls = fcor_cls
     &           + 1.d0 / beta * log ( beta*hbar*omega )

         end if

c     //   loop of modes
      end do

c     //   total energy correction
      ecor = ecor_c + ecor_t

c-----------------------------------------------------------------------

       au_kcalmol = si_kcalmol / si_hartree
       au_kjmol   = si_kjmol   / si_hartree
       au_ev      = si_ev      / si_hartree

       write( 6, '(a)' )

       write( 6, '(a)' )
     &   'Quantum statistics            ' //
     &   '   hartree  kcal/mol' //
     &   '    kJ/mol        eV'

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Quantum vib zero point energy:',
     &   ecor_z, ecor_z/au_kcalmol, ecor_z/au_kjmol, ecor_z/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Thermal vib excitation energy:',
     &   (ecor_t-ecor_z), (ecor_t-ecor_z)/au_kcalmol,
     &   (ecor_t-ecor_z)/au_kjmol, (ecor_t-ecor_z)/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Thermal trans and rot energy: ',
     &   ecor_c, ecor_c/au_kcalmol, ecor_c/au_kjmol, ecor_c/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Total energy correction:      ',
     &   ecor, ecor/au_kcalmol, ecor/au_kjmol, ecor/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Entropy correction -TS:       ',
     &   (fcor-ecor), (fcor-ecor)/au_kcalmol,
     &   (fcor-ecor)/au_kjmol, (fcor-ecor)/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Free energy correction:       ',
     &   fcor, fcor/au_kcalmol, fcor/au_kjmol, fcor/au_ev

       write( 6, '(a)' )

       write( 6, '(a)' )
     &   'Classical statistics          ' //
     &   '   hartree  kcal/mol' //
     &   '    kJ/mol        eV'

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Total energy correction (cls):',
     &   ecor_cls, ecor_cls/au_kcalmol,
     &   ecor_cls/au_kjmol, ecor_cls/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Entropy correction -TS (cls): ',
     &   (fcor_cls-ecor_cls), (fcor-ecor_cls)/au_kcalmol,
     &   (fcor_cls-ecor_cls)/au_kjmol, (fcor_cls-ecor_cls)/au_ev

       write( 6, '(a,f10.5,2f10.2,f10.3)' )
     &   'Free energy correction (cls): ',
     &   fcor_cls, fcor_cls/au_kcalmol,
     &   fcor_cls/au_kjmol, fcor_cls/au_ev

      write( 6, '(a)' )

c-----------------------------------------------------------------------

      stop
      end
