#!/bin/bash

if [ $# -le 1 ]; then
  echo "                             "
  echo "USAGE: mtdcheck.bash x y ... "
  echo "       x: number of beads    "
  echo "       y: directory name(s)  "
  echo "                             "
  exit
fi

nbead=$1

array=($2 $3 $4 $5 $6 $7 $8 $9)

for i in `seq ${#array[@]}`; do

cdir=${array[$i-1]}

echo "------------------------------------------------------------------------------"
echo "DIRECTORY:   " $cdir
echo "------------------------------------------------------------------------------"

echo; echo "LAST STEPS:  "
cd $cdir; tail -3 standard.out; cd ..; echo

var1=`head -1 $cdir/rec.out | cut -c 49-64`
var2=`echo "$var1*627.51" | bc`
var3=`echo "$nbead+2" | bc`

echo HILLS HEIGHT:
echo " " $var1 hartree, $var2 kcal/mol; echo

cd $cdir; cv2detect.x > TMP; tail -$var3 TMP; rm TMP; cd ..

done
exit
