c***********************************************************************
      program latticeexpand
c***********************************************************************
c-----------------------------------------------------------------------

      implicit none
      integer :: natom
      real(8), dimension(:), allocatable :: x, y, z
      real(8), dimension(:,:), allocatable :: s
      real(8), dimension(:,:), allocatable :: h, hinv
      real(8) :: bohr2ang = 0.529177246d0

      character(len=80) :: inputfile, outputfile, boxfile, char
      character(len=4), dimension(:), allocatable :: symbol
      integer :: iargc

      real(8) :: sa, sb, sc, xe, ye, ze
      integer :: i, na, nb, nc, ia, ib, ic, ierr

c-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Program latticeexpand'
      write( 6, '(a)' )

      if ( iargc() .ne. 6 ) then

         write( 6, '(a)' ) 'Usage: latticeexpand.x $1 $2 $3 $4 $5 $6'
         write( 6, '(a)' )
         write( 6, '(a)' ) '   $1: input xyz file'
         write( 6, '(a)' ) '   $2: output xyz file'
         write( 6, '(a)' ) '   $3: box data file (input.dat)'
         write( 6, '(a)' ) '   $4: replication in a axis'
         write( 6, '(a)' ) '   $5: replication in b axis'
         write( 6, '(a)' ) '   $6: replication in c axis'
         write( 6, '(a)' )

         stop

      end if

c-----------------------------------------------------------------------

      call getarg( 1, inputfile )
      call getarg( 2, outputfile )
      call getarg( 3, boxfile )
      call getarg( 4, char )
      read( char, * ) na
      call getarg( 5, char )
      read( char, * ) nb
      call getarg( 6, char )
      read( char, * ) nc

c-----------------------------------------------------------------------

      open ( 10, file = trim(inputfile) )
      read ( 10, *, iostat=ierr ) natom
      close( 10 )

c-----------------------------------------------------------------------

      allocate( symbol(natom) )
      allocate( x(natom) )
      allocate( y(natom) )
      allocate( z(natom) )
      allocate( s(3,natom) )
      allocate( h(3,3) )
      allocate( hinv(3,3) )

c-----------------------------------------------------------------------

      open ( 12, file = trim(boxfile) )
      do
         read( 12, *, iostat=ierr ) char
         if ( ierr .ne. 0 ) exit
         if ( char(1:11) .eq. '<iboundary>' ) then
            read( 12, *, iostat=ierr ) char
            read( 12, *, iostat=ierr ) h(1,1:3)
            read( 12, *, iostat=ierr ) h(2,1:3)
            read( 12, *, iostat=ierr ) h(3,1:3)
            if ( ierr .ne. 0 ) exit
            if ( ( char(1:1) .eq. '1' ) .or.
     &           ( char(1:1) .eq. '2' ) .or.
     &           ( char(1:4) .eq. 'BOHR' ) ) then
               h(:,:) = h(:,:) * bohr2ang
               exit
            else if ( char(1:8) .eq. 'ANGSTROM' ) then
               exit
            else
               ierr = 1
               exit
            end if
         end if
      end do

      if ( ierr .ne. 0 ) then
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Error in ' // trim(boxfile) // '.'
         stop
      end if

      call inv3( h, hinv )

c-----------------------------------------------------------------------

      open ( 10, file = trim(inputfile) )
      open ( 11, file = trim(outputfile) )

c-----------------------------------------------------------------------

      do

         read ( 10, *, iostat=ierr )
         read ( 10, *, iostat=ierr )
         do i = 1, natom
            read( 10, *, iostat=ierr ) symbol(i), x(i), y(i), z(i)
         end do

         if ( ierr .ne. 0 ) exit

         do i = 1, natom
            s(1,i) = hinv(1,1)*x(i) + hinv(1,2)*y(i) + hinv(1,3)*z(i)
            s(2,i) = hinv(2,1)*x(i) + hinv(2,2)*y(i) + hinv(2,3)*z(i)
            s(3,i) = hinv(3,1)*x(i) + hinv(3,2)*y(i) + hinv(3,3)*z(i)
         end do

         write( 11, '(i8)' ) natom*na*nb*nc
         write( 11, '(a)' ) 'ANGSTROM'
         do ia = 1, na
         do ib = 1, nb
         do ic = 1, nc
            do i = 1, natom
               sa = s(1,i) + dble(ia-1)
               sb = s(2,i) + dble(ib-1)
               sc = s(3,i) + dble(ic-1)
               xe = h(1,1)*sa + h(1,2)*sb + h(1,3)*sc
               ye = h(2,1)*sa + h(2,2)*sb + h(2,3)*sc
               ze = h(3,1)*sa + h(3,2)*sb + h(3,3)*sc
               write( 11, '(a,3f12.6)' ) symbol(i), xe, ye, ze
            end do
         end do
         end do
         end do

      end do

c-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Normal termination.'
      write( 6, '(a)' )

      stop
      end





c***********************************************************************
      subroutine inv3 ( a, ainv )
c***********************************************************************

c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: a(3,3), ainv(3,3), det3, deta

c-----------------------------------------------------------------------
c     /*   start                                                      */
c-----------------------------------------------------------------------

      ainv(1,1) = + a(2,2)*a(3,3) - a(2,3)*a(3,2)
      ainv(1,2) = + a(3,2)*a(1,3) - a(1,2)*a(3,3)
      ainv(1,3) = + a(1,2)*a(2,3) - a(2,2)*a(1,3)

      ainv(2,1) = + a(2,3)*a(3,1) - a(3,3)*a(2,1)
      ainv(2,2) = + a(3,3)*a(1,1) - a(3,1)*a(1,3)
      ainv(2,3) = + a(1,3)*a(2,1) - a(2,3)*a(1,1)

      ainv(3,1) = + a(2,1)*a(3,2) - a(3,1)*a(2,2)
      ainv(3,2) = + a(3,1)*a(1,2) - a(1,1)*a(3,2)
      ainv(3,3) = + a(1,1)*a(2,2) - a(1,2)*a(2,1)

      deta = det3 ( a )

      do j = 1, 3
      do i = 1, 3
         ainv(i,j) = ainv(i,j)/deta
      end do
      end do

      return
      end





c***********************************************************************
      real(8) function det3 ( a )
c***********************************************************************

c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      real(8) :: a(3,3)

c-----------------------------------------------------------------------
c     /*   start                                                      */
c-----------------------------------------------------------------------

      det3 = + a(1,1)*a(2,2)*a(3,3) - a(1,1)*a(2,3)*a(3,2)
     &       + a(2,1)*a(3,2)*a(1,3) - a(2,1)*a(1,2)*a(3,3)
     &       + a(3,1)*a(1,2)*a(2,3) - a(3,1)*a(2,2)*a(1,3)

      return
      end
