      program lammps2eam

      implicit none
      integer :: nrho, nr, i, n
      real(8) :: drho, dr, cutoff, phir, r, rho
      real(8), dimension(:), allocatable :: frho, zr, rhor, dat
      character(len=80) :: inputfile

      call getarg( 1, inputfile )

      open ( 10, file = inputfile )

      read( 10, * ) 
      read( 10, * ) 
      read( 10, * ) nrho, drho, nr, dr, cutoff

      if ( nrho .ne. nr ) stop

      n = nrho

      allocate( dat(3*n) )
      allocate( frho(n) )
      allocate( zr(n)   )
      allocate( rhor(n) )

      read( 10, * ) dat(1:3*n)

      close( 10 )

      do i = 1, n
         frho(i) = dat(i)
      end do

      do i = 1, n
         zr(i)   = dat(i+n)
      end do

      do i = 1, n
         rhor(i) = dat(i+2*n)
      end do

      open ( 11, file = 'eam.dat' )

      write( 11, '(a)' ) '<nref_eam>'
      write( 11, '(i6)' ) n

      write( 11, '(a)' )
      write( 11, '(a)' ) '<rcut_eam>'
      write( 11, '(e24.16)' ) cutoff

      write( 11, '(a)' )
      write( 11, '(a)' ) '<rhor_eam>'
      write( 11, '(a)' ) '1'
      do i = 1, n
         r = dble(i-1)*dr
         write( 11, '(2e24.16)' ) r, rhor(i)
      end do

      write( 11, '(a)' )
      write( 11, '(a)' ) '<frho_eam>'
      write( 11, '(a)' ) '1'
      do i = 1, n
         rho = dble(i-1)*drho
         write( 11, '(2e24.16)' ) rho, frho(i)
      end do

      write( 11, '(a)' )
      write( 11, '(a)' ) '<phir_eam>'
      write( 11, '(a)' ) '1 1'
      do i = 1, n
         r = dble(i-1)*dr
         phir = 27.2d0*0.529d0*zr(i)*zr(i) / max(r,dr)
         write( 11, '(2e24.16)' ) dble(i-1)*dr, phir
      end do

      close( 11 )

      stop
      end

