!***********************************************************************
      program hcpsurface
!***********************************************************************
!-----------------------------------------------------------------------
!     //   variables
!-----------------------------------------------------------------------

      implicit none

      integer :: na, nb, nc, ia, ib, ic, i, natom, iargc
      real(8) :: ax, ay, az, bx, by, bz, cx, cy, cz
      real(8) :: dx, dy, dz, ex, ey, ez, fx, fy, fz
      real(8) :: ua, ub, uc, va, vb, vc, a, r, c
      real(8), dimension(:), allocatable :: x, y, z
      character(len=80) :: char
      character(len=4) :: symbol
      integer :: ioption = 1

!-----------------------------------------------------------------------
!     //   initial message
!-----------------------------------------------------------------------

      if ( iargc() .ne. 6 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program hcpsurface'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Creates hcp surface'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Usage: hcpsurface.x $1 $2 $3 $4 $5 $6'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: Atomic element'
         write( 6, '(a)' ) '$2: a vector [Angstrom]'
         write( 6, '(a)' ) '$3: c vector [Angstrom]'
         write( 6, '(a)' ) '$4: number of cells in a direction'
         write( 6, '(a)' ) '$5: number of cells in b direction'
         write( 6, '(a)' ) '$6: number of cells in c direction'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'If $3 < 0, c vector is reset automatically'
         write( 6, '(a)' )
         write( 6, '(a)' ) &
    &                  'Example: ./hcpsurface.x Ru 2.7059 4.2815 3 4 2'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Ru:  V. A. Finkel, M. I. Palatnik, G. P.'
         write( 6, '(a)' ) 'Kovtun, Phys. Met. Metall. 32, 231 (1971).'
         write( 6, '(a)' )

         stop

      end if

!-----------------------------------------------------------------------
!     //   read values
!-----------------------------------------------------------------------

      call getarg( 1, symbol )
      call getarg( 2, char )
      read( char, * ) a
      call getarg( 3, char )
      read( char, * ) c
      call getarg( 4, char )
      read( char, * ) na
      call getarg( 5, char )
      read( char, * ) nb
      call getarg( 6, char )
      read( char, * ) nc

!-----------------------------------------------------------------------
!     //   atoms
!-----------------------------------------------------------------------

      natom = 2*na*nb*nc

      r = a / 2.d0

      allocate( x(natom) )
      allocate( y(natom) )
      allocate( z(natom) )

!-----------------------------------------------------------------------
!     //   unit cell vectors
!-----------------------------------------------------------------------

      ax = 2.d0 * r
      ay = 0.d0
      az = 0.d0

      bx = 1.d0 * r
      by = sqrt(3.d0) * r
      bz = 0.d0

      cx = 0.d0
      cy = 0.d0
      if ( c .le. 0.d0 ) then
         cz = 4.d0*sqrt(6.d0)/3.d0 * r
      else
         cz = c
      end if

!-----------------------------------------------------------------------
!     //   atoms in unit cell
!-----------------------------------------------------------------------

      ua = 0.d0
      ub = 0.d0
      uc = 0.d0

      va = 1.d0/3.d0
      vb = 1.d0/3.d0
      vc = 0.5d0

!-----------------------------------------------------------------------
!     //   atomic coordinates
!-----------------------------------------------------------------------

      i = 0

      do ic = 1, nc
      do ib = 1, nb
      do ia = 1, na

         x(i+1) = (ua+ia)*ax + (ub+ib)*bx + (uc+ic)*cx
         y(i+1) = (ua+ia)*ay + (ub+ib)*by + (uc+ic)*cy
         z(i+1) = (ua+ia)*az + (ub+ib)*bz + (uc+ic)*cz

         x(i+2) = (va+ia)*ax + (vb+ib)*bx + (vc+ic)*cx
         y(i+2) = (va+ia)*ay + (vb+ib)*by + (vc+ic)*cy
         z(i+2) = (va+ia)*az + (vb+ib)*bz + (vc+ic)*cz

         i = i + 2

      end do
      end do
      end do

!-----------------------------------------------------------------------
!     //   supercell ( parallel piped or rectangular )
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         dx = na*ax
         dy = na*ay
         dz = na*az
         ex = nb*bx
         ey = nb*by
         ez = nb*bz
         fx = nc*cx
         fy = nc*cy
         fz = nc*cz

      else

         dx = ax * na
         dy = 0.d0
         dz = 0.d0
         ex = 0.d0
         ey = by * nb
         ez = 0.d0
         fx = 0.d0
         fy = 0.d0
         fz = cz * nc

         do i = 1, natom
            if ( x(i) .gt. dx   ) x(i) = x(i) - dx
            if ( x(i) .lt. 0.d0 ) x(i) = x(i) + dx
            if ( y(i) .gt. dy   ) y(i) = y(i) - ey
            if ( y(i) .lt. 0.d0 ) y(i) = y(i) + ey
            if ( z(i) .gt. dz   ) z(i) = z(i) - fz
            if ( z(i) .lt. 0.d0 ) z(i) = z(i) + fz
         end do

      end if

!-----------------------------------------------------------------------
!     //   output
!-----------------------------------------------------------------------

      write( 6, '(a)' )
      write( 6, '(a)' ) 'Supercell for input.dat:'
      write( 6, '(a)' )
      write( 6, '(a)' ) '<iboundary>'
      write( 6, '(a)' ) 'ANGSTROM'
      write( 6, '(3f12.6)' ) dx, ex, fx
      write( 6, '(3f12.6)' ) dy, ey, fy
      write( 6, '(3f12.6)' ) dz, ez, fz
      write( 6, '(a)' )

      write( 6, '(a)' ) 'Enlarge zz value to make a vacuum.'
      write( 6, '(a)' )

      open ( 10, file = 'structure.xyz' )
      write( 10, '(i3)' ) natom
      write( 10, '(a)' ) 'ANGSTROM'
      do i = 1, natom
         write( 10, '(a4,3f12.5,i2)' ) symbol, x(i), y(i), z(i), 1
      end do
      close( 10 )

      write( 6, '(a)' ) 'Atomic coordinates written to structure.xyz.'
      write( 6, '(a)' )

!-----------------------------------------------------------------------
!     //   end of code
!-----------------------------------------------------------------------

      stop
      end
