c***********************************************************************
      program dipacf
c***********************************************************************
c-----------------------------------------------------------------------
c     //   variables
c-----------------------------------------------------------------------

c     //   local variables
      implicit none

c     //   dipole moment
      real(8), dimension(:), allocatable :: dipx, dipy, dipz

c     //   average dipole moment
      real(8), dimension(:), allocatable :: dx, dy, dz

c     //   autocorrelation function
      real(8), dimension(:), allocatable :: cxx, cxy, cxz, cyy, cyz, czz

c     //   step counter
      real(8), dimension(:), allocatable :: steps

c     //   number of beads
      integer :: nbead

c     //   number of steps
      integer :: nstep

c     //   correlation steps
      integer :: mstep

c     //   characters
      character(len=80) :: char

c     //   filenames
      character(len=80) :: inputfile, outputfile

c     //   integers
      integer :: j, k, istep, jstep, kstep, ierr

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      if ( iargc() .ne. 4 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program dipacf'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Usage: dipacf.x $1 $2 $3 $4'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: input filename for dipole trajectory'
         write( 6, '(a)' ) '$2: output filename for dipole acf'
         write( 6, '(a)' ) '$3: number of beads'
         write( 6, '(a)' ) '$4: correlation steps'
         write( 6, '(a)' )

         stop

      end if

c-----------------------------------------------------------------------
c     //   read values
c-----------------------------------------------------------------------

c     //   input filename
      call getarg( 1, inputfile )

c     //   output filename
      call getarg( 2, outputfile )

c     //   number of beads
      call getarg( 3, char )
      read( char, * ) nbead

c     //   correlation steps
      call getarg( 4, char )
      read( char, * ) mstep

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

      allocate( dipx(nbead) )
      allocate( dipy(nbead) )
      allocate( dipz(nbead) )

c-----------------------------------------------------------------------
c     //   read dipole trajectory
c-----------------------------------------------------------------------

      open( 10, file = inputfile )

      nstep = 0

      do

         do j = 1, nbead
            read( 10, *, iostat=ierr ) k, dipx(j), dipy(j), dipz(j)
         end do

         if ( ierr .ne. 0 ) exit

         nstep = nstep + 1

      end do

      close( 10 )

c-----------------------------------------------------------------------
c     //   initialize of average dipole moment
c-----------------------------------------------------------------------

      allocate( dx(nstep) )
      allocate( dy(nstep) )
      allocate( dz(nstep) )

      dx(:) = 0.d0
      dy(:) = 0.d0
      dz(:) = 0.d0

c-----------------------------------------------------------------------
c     //   read dipole trajectory
c-----------------------------------------------------------------------

      open( 10, file = inputfile )

      do istep = 1, nstep

         do j = 1, nbead
            read( 10, * ) k, dipx(j), dipy(j), dipz(j)
         end do

         do j = 1, nbead
            dx(istep) = dx(istep) + dipx(j) / dble(nbead)
            dy(istep) = dy(istep) + dipy(j) / dble(nbead)
            dz(istep) = dz(istep) + dipz(j) / dble(nbead)
         end do

      end do

      close( 10 )

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

      allocate( cxx(0:mstep) )
      allocate( cxy(0:mstep) )
      allocate( cxz(0:mstep) )
      allocate( cyy(0:mstep) )
      allocate( cyz(0:mstep) )
      allocate( czz(0:mstep) )

      allocate( steps(0:mstep) )

      cxx(:) = 0.d0
      cxy(:) = 0.d0
      cxz(:) = 0.d0
      cyy(:) = 0.d0
      cyz(:) = 0.d0
      czz(:) = 0.d0

      steps(:) = 0.d0

c-----------------------------------------------------------------------
c     //   compute autocorrelation function
c-----------------------------------------------------------------------

      do istep = 1, nstep
      do jstep = istep, min(istep+mstep,nstep)

         kstep = jstep - istep

         steps(kstep) = steps(kstep) + 1.d0

         cxx(kstep) = cxx(kstep) + dx(istep) * dx(jstep)
         cxy(kstep) = cxy(kstep) + dx(istep) * dy(jstep)
         cxz(kstep) = cxz(kstep) + dx(istep) * dz(jstep)
         cyy(kstep) = cyy(kstep) + dy(istep) * dy(jstep)
         cyz(kstep) = cyz(kstep) + dy(istep) * dz(jstep)
         czz(kstep) = czz(kstep) + dz(istep) * dz(jstep)

      end do
      end do

      do kstep = 0, mstep

         if ( nint(steps(kstep)) .eq. 0 ) cycle

         cxx(kstep) = cxx(kstep) / steps(kstep)
         cxy(kstep) = cxy(kstep) / steps(kstep)
         cxz(kstep) = cxz(kstep) / steps(kstep)
         cyy(kstep) = cyy(kstep) / steps(kstep)
         cyz(kstep) = cyz(kstep) / steps(kstep)
         czz(kstep) = czz(kstep) / steps(kstep)

      end do

c-----------------------------------------------------------------------
c     //   print autocorrelation function
c-----------------------------------------------------------------------

      open( 11, file = outputfile )

      do kstep = 0, mstep

         write( 11, '(i5,6f10.5)' )
     &      kstep, cxx(kstep), cxy(kstep), cxz(kstep),
     &             cyy(kstep), cyz(kstep), czz(kstep)

      end do

      close( 11 )

c-----------------------------------------------------------------------

      stop
      end

