c***********************************************************************
      program dcddip2dip
c***********************************************************************
c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

c     /*   initialize   */
      implicit none

c     /*   integers   */
      integer :: nbead, nstep

c     /*   dipole moment   */
      real(8), dimension(:), allocatable :: dipx, dipy, dipz

c     //   filenames
      character(len=80) :: dcdfile, outfile

c     /*   integers   */
      integer :: i, j, istep, ierr

c     //   characters
      character(len=80) :: char

c     //   header variables
      real(4) :: vreal4
      integer(4) :: vint4
      character(len=4) :: vchar4
      character(len=80) :: vchar80

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      if ( iargc() .ne. 4 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program dcddip2dip'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Usage: dcddip2dip.x $1 $2 $3 $4'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: dcd dipole file (dip.dcd)'
         write( 6, '(a)' ) '$2: output dipole file (dipole.out)'
         write( 6, '(a)' ) '$3: number of beads'
         write( 6, '(a)' ) '$4: number of steps'
         write( 6, '(a)' )

         stop

      else

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program dcddip2dip'
         write( 6, '(a)' )

      end if

c-----------------------------------------------------------------------
c     //   read arguments
c-----------------------------------------------------------------------

      call getarg( 1, dcdfile )

      call getarg( 2, outfile )

      call getarg( 3, char )
      read( char, * ) nbead

      call getarg( 4, char )
      read( char, * ) nstep

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

      allocate( dipx(nbead) )
      allocate( dipy(nbead) )
      allocate( dipz(nbead) )

c-----------------------------------------------------------------------
c     //   check number of steps
c-----------------------------------------------------------------------

c     //   read number of steps
      if ( nstep .le. 0 ) then

c        //   open file
         open ( 10, file = trim(dcdfile), form = 'unformatted',
     &          access = 'stream', status = 'old' )

c        //   read header
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vchar4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4, vint4, vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vreal4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4, vint4, vint4, vint4,
     &                           vint4, vint4, vint4, vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vchar80
         read( 10, iostat=ierr ) vchar80
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4

c        //   detect error
         call error_handling( ierr, 'dcd file', 8 )

c        //   step counter
         istep = 0

c        //   counts
         do

c           //   read lines
            read( 10, iostat=ierr ) j
            do i = 1, nbead
               read( 10, iostat=ierr ) dipx(i)
               read( 10, iostat=ierr ) dipy(i)
               read( 10, iostat=ierr ) dipz(i)
            end do

c           //   exit on read error
            if ( ierr .ne. 0 ) exit

c           //   update counter
            istep = istep + 1

c        //   counts
         end do

c        //   close file
         close( 10 )

c        //   number of steps
         nstep = istep

c        //   print
         write( 6, '(a,i8)' ) 'Number of steps:', nstep
         write( 6, '(a)' )

c     //   read number of steps
      end if

c-----------------------------------------------------------------------
c     //   open files
c-----------------------------------------------------------------------

      open ( 10, file = trim(dcdfile), form = 'unformatted',
     &       access = 'stream', status = 'old' )

      open ( 11, file = trim(outfile) )

c-----------------------------------------------------------------------
c     //   skip header
c-----------------------------------------------------------------------

c     //   error flag
      ierr = 0

c     //   read header
      read( 10, iostat=ierr ) vint4

c     //   check endian
      if ( vint4 .ne. 84 ) ierr = 1

c     //   detect error
      call error_handling( ierr, 'endian', 6 )

      read( 10, iostat=ierr ) vchar4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4, vint4, vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vreal4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4, vint4, vint4, vint4,
     &                        vint4, vint4, vint4, vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vchar80
      read( 10, iostat=ierr ) vchar80
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4

c     //   detect error
      call error_handling( ierr, 'dcd file', 8 )

c-----------------------------------------------------------------------
c     //   main loop
c-----------------------------------------------------------------------

c     //   loop of steps
      do istep = 1, nstep

c        //   read
         read( 10, iostat=ierr ) j
         do i = 1, nbead
            read( 10, iostat=ierr ) dipx(i)
            read( 10, iostat=ierr ) dipy(i)
            read( 10, iostat=ierr ) dipz(i)
         end do

c        //   detect error
         call error_handling( ierr, 'dcd file', 8 )

c        //   print
         do i = 1, nbead
            write( 11, '(i8,3f24.16)' ) istep, dipx(i), dipy(i), dipz(i)
         end do

c     //   loop of steps
      end do

c-----------------------------------------------------------------------
c     //  close files
c-----------------------------------------------------------------------

      close( 10 )
      close( 11 )

c-----------------------------------------------------------------------
c     //   end of program
c-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Normal termination of dcddip2dip.'
      write( 6, '(a)' )

      return
      end





c***********************************************************************
      subroutine error_handling ( ierr, char_tag, length_tag )
c***********************************************************************

c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      integer:: ierr, length_tag

      character(len=length_tag) :: char_tag

c-----------------------------------------------------------------------
c     /*   start                                                      */
c-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         write(6,'(a)') 'Error termination at: ' // char_tag // '.'

         write(6,'(a)')

         stop

      end if

      return
      end
