c***********************************************************************
      program dcdchg2chg
c***********************************************************************
c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

c     /*   initialize   */
      implicit none

c     /*   integers   */
      integer :: nbead, natom, nstep

c     /*   charges   */
      real(4), dimension(:,:,:), allocatable :: q_es

c     //   filenames
      character(len=80) :: dcdfile, outfile

c     /*   integers   */
      integer :: i, j, istep, ierr

c     //   characters
      character(len=80) :: char

c     //   header variables
      real(4) :: vreal4
      integer(4) :: vint4
      character(len=4) :: vchar4
      character(len=80) :: vchar80

c-----------------------------------------------------------------------
c     //   initial message
c-----------------------------------------------------------------------

      if ( iargc() .ne. 6 ) then

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program dcdchg2chg'
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Usage: dcdchg2chg.x $1 $2 $3 $4 $5'
         write( 6, '(a)' )
         write( 6, '(a)' ) '$1: dcd charge file (charges.dcd)'
         write( 6, '(a)' ) '$2: output charge file (charges.out)'
         write( 6, '(a)' ) '$3: number of atoms'
         write( 6, '(a)' ) '$4: number of beads'
         write( 6, '(a)' ) '$5: number of steps'
         write( 6, '(a)' )

         stop

      else

         write( 6, '(a)' )
         write( 6, '(a)' ) 'Program dcdchg2chg'
         write( 6, '(a)' )

      end if

c-----------------------------------------------------------------------
c     //   read arguments
c-----------------------------------------------------------------------

      call getarg( 1, dcdfile )

      call getarg( 2, outfile )

      call getarg( 3, char )
      read( char, * ) natom

      call getarg( 4, char )
      read( char, * ) nbead

      call getarg( 5, char )
      read( char, * ) nstep

c-----------------------------------------------------------------------
c     //   memory allocation
c-----------------------------------------------------------------------

      allocate( q_es(2,natom,nbead) )

c-----------------------------------------------------------------------
c     //   check number of steps
c-----------------------------------------------------------------------

c     //   read number of steps
      if ( nstep .le. 0 ) then

c        //   open file
         open ( 10, file = trim(dcdfile), form = 'unformatted',
     &          access = 'stream', status = 'old' )

c        //   read header
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vchar4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4, vint4, vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vreal4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4, vint4, vint4, vint4,
     &                           vint4, vint4, vint4, vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vchar80
         read( 10, iostat=ierr ) vchar80
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4
         read( 10, iostat=ierr ) vint4

c        //   step counter
         istep = 0

c        //   counts
         do

c           //   read lines
            read( 10, iostat=ierr ) j
            do i = 1, nbead
               do j = 1, natom
                  read( 10, iostat=ierr ) q_es(1,j,i)
               end do
               do j = 1, natom
                  read( 10, iostat=ierr ) q_es(2,j,i)
               end do
            end do

c           //   detect error
            call error_handling( ierr, 'dcd file', 8 )

c           //   exit on read error
            if ( ierr .ne. 0 ) exit

c           //   update counter
            istep = istep + 1

c        //   counts
         end do

c        //   close file
         close( 10 )

c        //   number of steps
         nstep = istep

c        //   print
         write( 6, '(a,i8)' ) 'Number of steps:', nstep
         write( 6, '(a)' )

c     //   read number of steps
      end if

c-----------------------------------------------------------------------
c     //   open files
c-----------------------------------------------------------------------

      open ( 10, file = trim(dcdfile), form = 'unformatted',
     &       access = 'stream', status = 'old' )

      open ( 11, file = trim(outfile) )

c-----------------------------------------------------------------------
c     //   skip header
c-----------------------------------------------------------------------

c     //   error flag
      ierr = 0

c     //   read header
      read( 10, iostat=ierr ) vint4

c     //   check endian
      if ( vint4 .ne. 84 ) ierr = 1

c     //   detect error
      call error_handling( ierr, 'endian', 6 )

c     //   read header
      read( 10, iostat=ierr ) vchar4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4, vint4, vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vreal4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4, vint4, vint4, vint4,
     &                        vint4, vint4, vint4, vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vchar80
      read( 10, iostat=ierr ) vchar80
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4
      read( 10, iostat=ierr ) vint4

c     //   detect error
      call error_handling( ierr, 'dcd file', 8 )

c-----------------------------------------------------------------------
c     //   main loop
c-----------------------------------------------------------------------

c     //   loop of steps
      do istep = 1, nstep

c        //   read
         read( 10, iostat=ierr ) j
         do i = 1, nbead
            do j = 1, natom
               read( 10, iostat=ierr ) q_es(1,j,i)
            end do
            do j = 1, natom
               read( 10, iostat=ierr ) q_es(2,j,i)
            end do
         end do

c        //   detect error
         call error_handling( ierr, 'dcd file', 8 )

c        //   detect error
         call error_handling( ierr, 'dcd file', 8 )

c        //   print
         do i = 1, nbead
         do j = 1, natom
            write( 11, '(i8,2f12.6)' ) istep, q_es(1,j,i), q_es(2,j,i)
         end do
         end do

c     //   loop of steps
      end do

c-----------------------------------------------------------------------
c     //  close files
c-----------------------------------------------------------------------

      close( 10 )
      close( 11 )

c-----------------------------------------------------------------------
c     //   end of program
c-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Normal termination of dcdchg2chg.'
      write( 6, '(a)' )

      return
      end





c***********************************************************************
      subroutine error_handling ( ierr, char_tag, length_tag )
c***********************************************************************

c-----------------------------------------------------------------------
c     /*   local variables                                            */
c-----------------------------------------------------------------------

      implicit none

      integer:: ierr, length_tag

      character(len=length_tag) :: char_tag

c-----------------------------------------------------------------------
c     /*   start                                                      */
c-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         write(6,'(a)') 'Error termination at: ' // char_tag // '.'

         write(6,'(a)')

         stop

      end if

      return
      end
