c///////////////////////////////////////////////////////////////////////
c
c      Author:          M. Shiga
c      Last updated:    Feb 16, 2020 by M. Shiga
c      Description:     plot cv.out
c
c///////////////////////////////////////////////////////////////////////
c***********************************************************************
      program cv2plot
c***********************************************************************

      implicit none

c     //   integers
      integer :: i, ierr, nskip

c     //   character
      character(len=24) :: cv1, cv2, cv3, cv4

c     //   real number
      real(8) :: cvx, cvy, cvz

c     //   file unit
      integer :: iounit = 10

c     //   flags
      integer :: ipbc_x = 0
      integer :: ipbc_y = 0
      integer :: ipbc_z = 0

c     //   logical
      logical :: file_exists

c-----------------------------------------------------------------------
c     //   read parameters
c-----------------------------------------------------------------------

c     //   error flag
      ierr = 1

c     //   file
      inquire( file='cv2plot.dat', exist=file_exists )

c     //   read from file
      if ( file_exists ) then

c        //   open file
         open ( iounit, file='cv2plot.dat' )

c        //   input file
         read( iounit, *, iostat=ierr ) cv1, cv2, cv3, cv4

c        //   close file
         close( iounit )

c        //   remove file
         if ( ierr .ne. 0 ) call system( 'rm cv2plot.dat' )

c     //   three arguments
      end if

c-----------------------------------------------------------------------
c     //   usage
c-----------------------------------------------------------------------

c     //   four arguments
      if ( ( ierr .ne. 0 ) .and. ( iargc() .ne. 4 ) ) then

c        //   print message
         write( 6, * ) 
         write( 6, * ) 'CODE:        cv2plot.x'
         write( 6, * ) 
         write( 6, * ) 'INPUT FILE:  cv.out'
         write( 6, * ) 'STD OUTPUT:  gnuplot of cv trajectory'
         write( 6, * ) 
         write( 6, * ) 'USAGE:       cv2plot.x $1 $2 $3 $4'
         write( 6, * ) '$1:          cv type of x.'
         write( 6, * ) '$2:          cv type of y.'
         write( 6, * ) '$3:          cv type of z.'
         write( 6, * ) '$4:          skipped steps.'
         write( 6, * ) 

c        //   error termination
         stop

c     //   four arguments
      end if

c-----------------------------------------------------------------------
c     //   read from command line
c-----------------------------------------------------------------------

c     //   four arguments
      if ( iargc() .eq. 4 ) then

c        //   read characters
         call getarg( 1, cv1 )
         call getarg( 2, cv2 )
         call getarg( 3, cv3 )
         call getarg( 4, cv4 )

c     //   four arguments
      end if

c-----------------------------------------------------------------------
c     //   transfer data type
c-----------------------------------------------------------------------

c     //   three arguments
      if ( iargc() .eq. 4 ) then

c        //   transform to integer
         read ( cv4, * ) nskip

c     //   four arguments
      end if

c-----------------------------------------------------------------------
c     //   write parameters
c-----------------------------------------------------------------------

c     //   new file
      if ( .not. file_exists ) then

c        //   open file
         open ( iounit, file = 'cv2plot.dat' )

c        //   input file
         write( iounit, '(a,1x,a,1x,a,1x,a)' )
     &      trim(cv1), trim(cv2), trim(cv3), trim(cv4)

c        //   close file
         close( iounit )

c     //   new file
      end if

c-----------------------------------------------------------------------
c     //   print message
c-----------------------------------------------------------------------

      write( 6, '(a)' ) 'CV TYPE OF X:  ' // trim(cv1)
      write( 6, '(a)' ) 'CV TYPE OF Y:  ' // trim(cv2)
      write( 6, '(a)' ) 'CV TYPE OF Z:  ' // trim(cv3)
      write( 6, '(a)' ) 'SKIPPED STEPS: ' // trim(cv4)

c-----------------------------------------------------------------------
c     //   periodic condition
c-----------------------------------------------------------------------

      if ( cv1(1:5) .eq. 'DIH  ' ) ipbc_x = 1
      if ( cv2(1:5) .eq. 'DIH  ' ) ipbc_y = 1
      if ( cv3(1:5) .eq. 'DIH  ' ) ipbc_z = 1

c-----------------------------------------------------------------------
c     //   main loop start
c-----------------------------------------------------------------------

c     //   open files
      open ( 10, file = 'cv.out' )
      open ( 11, file = 'cv2plot.out' )

c     //   read lines
      read( 10, *, iostat=ierr )
      read( 10, *, iostat=ierr )
      read( 10, *, iostat=ierr )

c     //   loop start
      do

c        //   read step and cv position
         read( 10, *, iostat=ierr ) i, cvx
         read( 10, *, iostat=ierr ) i, cvy
         read( 10, *, iostat=ierr ) i, cvz

c        //   detect skipped steps
         if ( i .le. nskip ) cycle

c        //   detect end of file
         if ( ierr .ne. 0 ) exit

c        //   periodic condition
         if ( (ipbc_x.eq.1) .and. (cvx.lt.0.d0)   ) cvx = cvx + 360.d0
         if ( (ipbc_y.eq.1) .and. (cvy.lt.0.d0)   ) cvy = cvy + 360.d0
         if ( (ipbc_z.eq.1) .and. (cvz.lt.0.d0)   ) cvz = cvz + 360.d0
         if ( (ipbc_x.eq.1) .and. (cvx.gt.360.d0) ) cvx = cvx - 360.d0
         if ( (ipbc_y.eq.1) .and. (cvy.gt.360.d0) ) cvy = cvy - 360.d0
         if ( (ipbc_z.eq.1) .and. (cvz.gt.360.d0) ) cvz = cvz - 360.d0

c        //   print step and cv position
         write( 11, '(i8,3e16.8)' ) i, cvx, cvy, cvz

c     //   loop end
      end do

c-----------------------------------------------------------------------
c     //   main loop end
c-----------------------------------------------------------------------

c     //   close files
      close( 10 )
      close( 11 )

c-----------------------------------------------------------------------
c     //   set gnuplot
c-----------------------------------------------------------------------

c     //   open file
      open ( 12, file = 'cv.plt' )

c     //   cvx and cvy
      write( 12, '(a)' ) "unset key"
      write( 12, '(a)' ) "set xlabel 'cv1'"
      write( 12, '(a)' ) "set ylabel 'cv2'"
      write( 12, '(a)' ) "plot  'cv2plot.out' u 2:3 w p ps 0.1"
      write( 12, '(a)' ) "pause -1"

c     //   cvz and cvy
      write( 12, '(a)' ) "set xlabel 'cv2'"
      write( 12, '(a)' ) "set ylabel 'cv3'"
      write( 12, '(a)' ) "plot  'cv2plot.out' u 3:4 w p ps 0.1"
      write( 12, '(a)' ) "pause -1"

c     //   cvx and cvz
      write( 12, '(a)' ) "set xlabel 'cv1'"
      write( 12, '(a)' ) "set ylabel 'cv3'"
      write( 12, '(a)' ) "plot  'cv2plot.out' u 2:4 w p ps 0.1"
      write( 12, '(a)' ) "pause -1"

c     //   cvx, cvy, cvz
      write( 12, '(a)' ) "set xlabel 'cv1'"
      write( 12, '(a)' ) "set ylabel 'cv2'"
      write( 12, '(a)' ) "set zlabel 'cv3'"
      write( 12, '(a)' ) "splot 'cv2plot.out' u 2:3:4 w p ps 0.1"
      write( 12, '(a)' ) "pause -1"

c     //   close file
      close( 12 )

c-----------------------------------------------------------------------
c     //   run gnuplot
c-----------------------------------------------------------------------

      call system( 'gnuplot cv.plt' )

c-----------------------------------------------------------------------
c     //   remove files
c-----------------------------------------------------------------------

      call system( 'rm cv2plot.out cv.plt' )

      stop
      end
      