c///////////////////////////////////////////////////////////////////////
c
c      Author:          M. Shiga
c      Last updated:    Feb 17, 2020 by M. Shiga
c      Description:     detect reaction from cv.out
c
c///////////////////////////////////////////////////////////////////////
c***********************************************************************
      program cv2detect
c***********************************************************************

c     //   clear variables
      implicit none

c     //   integers
      integer :: i, j, ierr, nbead

c     //   character
      character(len=24) :: cv1, cv2, cv3, cv4, cv5, cv6, cv7

c     //   real numbers
      real(8) :: xhi, xlo, yhi, ylo, zhi, zlo, c1, c2, c3

c     //   real numbers
      real(8), dimension(:), allocatable :: cvx, cvy, cvz

c     //   file unit
      integer :: iounit = 10

c     //   character
      logical :: file_exists

c     //   file unit
      integer, dimension(:), allocatable :: jerr

c-----------------------------------------------------------------------
c     //   read parameters
c-----------------------------------------------------------------------

c     //   error flag
      ierr = 1

c     //   file
      inquire( file='cv2detect.dat', exist=file_exists )

c     //   read from file
      if ( file_exists ) then

c        //   open file
         open ( iounit, file='cv2detect.dat' )

c        //   input file
         read( iounit, *, iostat=ierr )
     &      cv1, cv2, cv3, cv4, cv5, cv6, cv7

c        //   close file
         close( iounit )

c        //   remove file
         if ( ierr .ne. 0 ) call system( 'rm cv2detect.dat' )

c     //   three arguments
      end if

c-----------------------------------------------------------------------
c     //   usage
c-----------------------------------------------------------------------

c     //   four arguments
      if ( ( ierr .ne. 0 ) .and. ( iargc() .ne. 7 ) ) then

c        //   print message
         write( 6, * ) 
         write( 6, * ) 'CODE:        cv2detect.x'
         write( 6, * ) 
         write( 6, * ) 'INPUT FILE:  cv.out'
         write( 6, * ) 'STD OUTPUT:  detect a bead product state.'
         write( 6, * ) 
         write( 6, * ) 'USAGE:       cv2detect.x $1 $2 $3 $4 $5 $6 $7'
         write( 6, * ) '$1:          number of beads.'
         write( 6, * ) '$2:          lower bound of x in product.'
         write( 6, * ) '$3:          upper bound of x in product.'
         write( 6, * ) '$4:          lower bound of y in product.'
         write( 6, * ) '$5:          upper bound of y in product.'
         write( 6, * ) '$6:          lower bound of z in product.'
         write( 6, * ) '$7:          upper bound of z in product.'
         write( 6, * ) 

c        //   error termination
         stop

c     //   four arguments
      end if

c-----------------------------------------------------------------------
c     //   read from command line
c-----------------------------------------------------------------------

c     //   four arguments
      if ( iargc() .eq. 7 ) then

c        //   read characters
         call getarg( 1, cv1 )
         call getarg( 2, cv2 )
         call getarg( 3, cv3 )
         call getarg( 4, cv4 )
         call getarg( 5, cv5 )
         call getarg( 6, cv6 )
         call getarg( 7, cv7 )

c     //   four arguments
      end if

c-----------------------------------------------------------------------
c     //   transfer data type
c-----------------------------------------------------------------------

c     //   transform to integer
      read ( cv1, * ) nbead

c     //   transform to real numbers
      read ( cv2, * ) xlo
      read ( cv3, * ) xhi
      read ( cv4, * ) ylo
      read ( cv5, * ) yhi
      read ( cv6, * ) zlo
      read ( cv7, * ) zhi

c     //   flag
      allocate( jerr(nbead) )

c     //   cv
      allocate( cvx(nbead) )
      allocate( cvy(nbead) )
      allocate( cvz(nbead) )

c-----------------------------------------------------------------------
c     //   write parameters
c-----------------------------------------------------------------------

c     //   new file
      if ( .not. file_exists ) then

c        //   open file
         open ( iounit, file = 'cv2detect.dat' )

c        //   input file
         write( iounit, '(a,1x,a,1x,a,1x,a,1x,a,1x,a,1x,a)' )
     &      trim(cv1), trim(cv2), trim(cv3),
     &      trim(cv4), trim(cv5), trim(cv6), trim(cv7)

c        //   close file
         close( iounit )

c     //   new file
      end if

c-----------------------------------------------------------------------
c     //   print message
c-----------------------------------------------------------------------

      write( 6, '(a)' ) 
      write( 6, '(a)' ) 'NUMBER OF BEADS: ' // trim(cv1)

      write( 6, '(a)' ) 
      write( 6, '(a)' ) 'DEFINED PRODUCT STATE:'
      write( 6, '(a)' ) 'X: lower bound ' // trim(cv2) //
     &                   ', upper bound ' // trim(cv3)
      write( 6, '(a)' ) 'Y: lower bound ' // trim(cv4) //
     &                   ', upper bound ' // trim(cv5)
      write( 6, '(a)' ) 'Z: lower bound ' // trim(cv6) //
     &                   ', upper bound ' // trim(cv7)
      write( 6, '(a)' ) 

c-----------------------------------------------------------------------
c     //   main loop start
c-----------------------------------------------------------------------

c     //   reaction flag
      jerr(:) = 0

c     //   open files
      open (  iounit, file = 'cv.out' )

c     //   read lines
      read(  iounit, *, iostat=ierr )
      read(  iounit, *, iostat=ierr )
      read(  iounit, *, iostat=ierr )

      do

c        //   loop of beads
         do j = 1, nbead

c           //   read step and cv position
            read(  iounit, *, iostat=ierr ) i, c1
            read(  iounit, *, iostat=ierr ) i, c2
            read(  iounit, *, iostat=ierr ) i, c3

c           //   end of file detected
            if ( ierr .ne. 0 ) exit

c           //   substitution
            cvx(j) = c1
            cvy(j) = c2
            cvz(j) = c3

c           //   first reaction only
            if ( jerr(j) .ne. 0 ) cycle

c           //   detect reactant region
            if ( cvx(j) .lt. xlo ) cycle
            if ( cvx(j) .gt. xhi ) cycle
            if ( cvy(j) .lt. ylo ) cycle
            if ( cvy(j) .gt. yhi ) cycle
            if ( cvz(j) .lt. zlo ) cycle
            if ( cvz(j) .gt. zhi ) cycle

c           //   print message
            write( 6, '(a,i4,a,i8,a,3f9.3)' )
     &         'ARRIVED: bead ', j, ' step ', i,
     &         ' detected cv ', cvx(j), cvy(j), cvz(j)

c           //   reaction detected
            jerr(j) = i

c        //   loop of beads
         end do

c        //   exit from loop
         if ( ierr .ne. 0 ) exit

c     //   loop end
      end do

c-----------------------------------------------------------------------
c     //   main loop end
c-----------------------------------------------------------------------

c     //   close files
      close( iounit )

c-----------------------------------------------------------------------
c     //   print message
c-----------------------------------------------------------------------

      write( 6, '(a)' ) 
      write( 6, '(a,i8)' ) 'FINAL RESULT: step', i

      do j = 1, nbead
         if ( jerr(j) .eq. 0 ) write( 6, '(a,i4,a,3f9.3)' )   
     &      'bead ', j, ' DEPARTED  current cv ', cvx(j), cvy(j), cvz(j)
         if ( jerr(j) .ne. 0 ) write( 6, '(a,i4,a,3f9.3)' )
     &      'bead ', j, ' ARRIVED   current cv ', cvx(j), cvy(j), cvz(j)
      end do

      write( 6, '(a)' ) 

      stop
      end
