!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update Cartesian position and velocity
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_xyz
!***********************************************************************
!=======================================================================
!
!     update cartesian velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vx, vy, vz, dt, fx, fy, fz, physmass, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vx(i,j) = vx(i,j) + 0.5d0*dt*(fx(i,j)*nbead)/physmass(i)
         vy(i,j) = vy(i,j) + 0.5d0*dt*(fy(i,j)*nbead)/physmass(i)
         vz(i,j) = vz(i,j) + 0.5d0*dt*(fz(i,j)*nbead)/physmass(i)
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_ref_xyz
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by reference (harmonic) forces.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vx, vy, vz, dt_ref, fux_ref, fuy_ref, fuz_ref, physmass, &
     &   natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vx(i,j) = vx(i,j) &
     &           + 0.5d0*dt_ref*(fux_ref(i,j)*nbead)/physmass(i)
         vy(i,j) = vy(i,j) &
     &           + 0.5d0*dt_ref*(fuy_ref(i,j)*nbead)/physmass(i)
         vz(i,j) = vz(i,j) &
     &           + 0.5d0*dt_ref*(fuz_ref(i,j)*nbead)/physmass(i)
      end do
      end do

      return
      end

