!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update velocity in steepest descent dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_sd
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fx, fy, fz, vx, vy, vz, physmass, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i

      real(8) :: sum

!-----------------------------------------------------------------------
!     /*   velocity for intrinsic reaction coordinate                 */
!-----------------------------------------------------------------------

      sum = 0.d0

      do i = 1, natom
         sum = sum + fx(i,1)*fx(i,1)/physmass(i)
         sum = sum + fy(i,1)*fy(i,1)/physmass(i)
         sum = sum + fz(i,1)*fz(i,1)/physmass(i)
      end do

      sum = sqrt(sum)

      vx(:,:) = 0.d0
      vy(:,:) = 0.d0
      vz(:,:) = 0.d0

      if ( sum .eq. 0.d0 ) return

      do i = 1, natom
         vx(i,1) = fx(i,1)/physmass(i)/sum
         vy(i,1) = fy(i,1)/physmass(i)/sum
         vz(i,1) = fz(i,1)/physmass(i)/sum
      end do

      return
      end
