!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update velocities in multiple time scale method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_multi_me_ref_p ( ds_ref )
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by reference (harmonic) forces.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux_ref, fuy_ref, fuz_ref, fictmass, &
     &   natom, nbead

      use qmmm_variables, only : &
     &   layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: ds_ref

!-----------------------------------------------------------------------
!     /*   update                                                     */
!-----------------------------------------------------------------------

      do i = 1, natom
         if ( layer(i)(1:1) .ne. 'A' ) cycle
         do j = 1, nbead
            vux(i,j) = vux(i,j) &
     &               + 0.5d0*ds_ref*fux_ref(i,j)/fictmass(i,j)
            vuy(i,j) = vuy(i,j) &
     &               + 0.5d0*ds_ref*fuy_ref(i,j)/fictmass(i,j)
            vuz(i,j) = vuz(i,j) &
     &               + 0.5d0*ds_ref*fuz_ref(i,j)/fictmass(i,j)
         end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_multi_me_ref_s ( ds_ref )
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by reference (harmonic) forces.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux_ref, fuy_ref, fuz_ref, fictmass, &
     &   natom, nbead

      use qmmm_variables, only : &
     &   layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: ds_ref

!-----------------------------------------------------------------------
!     /*   update                                                     */
!-----------------------------------------------------------------------

      do i = 1, natom
         if ( layer(i)(1:1) .ne. 'B' ) cycle
         do j = 1, nbead
            vux(i,j) = vux(i,j) &
     &               + 0.5d0*ds_ref*fux_ref(i,j)/fictmass(i,j)
            vuy(i,j) = vuy(i,j) &
     &               + 0.5d0*ds_ref*fuy_ref(i,j)/fictmass(i,j)
            vuz(i,j) = vuz(i,j) &
     &               + 0.5d0*ds_ref*fuz_ref(i,j)/fictmass(i,j)
         end do
      end do

      return
      end
