!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update velocities in multiple time scale method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_multi_me_p ( ds )
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fictmass, natom, nbead

      use qmmm_variables, only : &
     &   fux_a, fuy_a, fuz_a

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: ds

!-----------------------------------------------------------------------
!     /*   update                                                     */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*ds*fux_a(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*ds*fuy_a(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*ds*fuz_a(i,j)/fictmass(i,j)
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_multi_me_s ( ds )
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fictmass, natom, nbead

      use qmmm_variables, only : &
     &   fux_b, fuy_b, fuz_b

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: ds

!-----------------------------------------------------------------------
!     /*   update                                                     */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*ds*fux_b(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*ds*fuy_b(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*ds*fuz_b(i,j)/fictmass(i,j)
      end do
      end do

      return
      end

