!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update centroid velocities in NtH ensemble
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_cent_nth_pp_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, vbox, dt_ref, cmtk, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      integer :: i, j, k

      real(8) :: factor, b(3,3), a(3,3), e(3)

!-----------------------------------------------------------------------
!     /*   friction term                                              */
!-----------------------------------------------------------------------

      factor = ( vbox(1,1)+vbox(2,2)+vbox(3,3) ) /dble(3*natom) * cmtk

      a(1,1) = + vbox(1,1) + factor
      a(1,2) = + vbox(1,2)
      a(1,3) = + vbox(1,3)
      a(2,1) = + vbox(2,1)
      a(2,2) = + vbox(2,2) + factor
      a(2,3) = + vbox(2,3)
      a(3,1) = + vbox(3,1)
      a(3,2) = + vbox(3,2)
      a(3,3) = + vbox(3,3) + factor

!-----------------------------------------------------------------------
!     /*   diagonalize friction                                       */
!-----------------------------------------------------------------------

      call ddiag_MPI ( a, e, b, 3 )

!-----------------------------------------------------------------------
!     /*   transform matrix                                           */
!-----------------------------------------------------------------------

      a(:,:) = 0.d0

      do i = 1, 3
      do j = 1, 3
      do k = 1, 3
         a(i,j) = a(i,j) + b(i,k) * exp( - e(k)*0.5d0*dt_ref ) * b(j,k)
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   update velocity due to box transform                       */
!-----------------------------------------------------------------------

      do i = 1, natom

         e(1) = a(1,1)*vux(i,1) + a(1,2)*vuy(i,1) + a(1,3)*vuz(i,1)
         e(2) = a(2,1)*vux(i,1) + a(2,2)*vuy(i,1) + a(2,3)*vuz(i,1)
         e(3) = a(3,1)*vux(i,1) + a(3,2)*vuy(i,1) + a(3,3)*vuz(i,1)

         vux(i,1) = e(1)
         vuy(i,1) = e(2)
         vuz(i,1) = e(3)

      end do

      return
      end

