!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update Cartesian velocity
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vx, vy, vz, fx, fy, fz, dt, physmass, vux, vuy, vuz, &
     &   natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

!-----------------------------------------------------------------------
!     /*   update velocity                                            */
!-----------------------------------------------------------------------

      do l = 1, nbead
      do k = 1, natom
         vx(k,l) = vx(k,l) + fx(k,l)*dt*0.5d0/physmass(k)
         vy(k,l) = vy(k,l) + fy(k,l)*dt*0.5d0/physmass(k)
         vz(k,l) = vz(k,l) + fz(k,l)*dt*0.5d0/physmass(k)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   save velocity                                              */
!-----------------------------------------------------------------------

      vux(:,:) = vx(:,:)
      vuy(:,:) = vy(:,:)
      vuz(:,:) = vz(:,:)

      return
      end
