!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update box velocities in NtH ensemble
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_box_nth_pp
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, volume, boxmass, volume_ref, pres_iso, cmtk, &
     &   sigma_ref, dt, vbox, pres, vir, boxdot, box, fictmass, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: ckin(3,3), factor(3,3), dkin

      integer :: i, j, k, l

!-----------------------------------------------------------------------
!     /*   kinetic energy matrix of centroids                         */
!-----------------------------------------------------------------------

      ckin(:,:) = 0.d0

      do i = 1, natom

         ckin(1,1) = ckin(1,1) + fictmass(i,1)*vux(i,1)*vux(i,1)
         ckin(1,2) = ckin(1,2) + fictmass(i,1)*vux(i,1)*vuy(i,1)
         ckin(1,3) = ckin(1,3) + fictmass(i,1)*vux(i,1)*vuz(i,1)
         ckin(2,1) = ckin(2,1) + fictmass(i,1)*vuy(i,1)*vux(i,1)
         ckin(2,2) = ckin(2,2) + fictmass(i,1)*vuy(i,1)*vuy(i,1)
         ckin(2,3) = ckin(2,3) + fictmass(i,1)*vuy(i,1)*vuz(i,1)
         ckin(3,1) = ckin(3,1) + fictmass(i,1)*vuz(i,1)*vux(i,1)
         ckin(3,2) = ckin(3,2) + fictmass(i,1)*vuz(i,1)*vuy(i,1)
         ckin(3,3) = ckin(3,3) + fictmass(i,1)*vuz(i,1)*vuz(i,1)

      end do

      ckin(:,:) = 0.5d0*ckin(:,:)

!-----------------------------------------------------------------------
!     /*   kinetic energy of centroids                                */
!-----------------------------------------------------------------------

      dkin = ckin(1,1) + ckin(2,2) + ckin(3,3)

!-----------------------------------------------------------------------
!     /*   pressure                                                   */
!-----------------------------------------------------------------------

      pres(:,:) = ( 2.d0*ckin(:,:) + vir(:,:) ) / volume

!-----------------------------------------------------------------------
!     /*   isotropic pressure                                         */
!-----------------------------------------------------------------------

      pres_iso = ( pres(1,1) + pres(2,2) + pres(3,3) ) / 3.d0

!-----------------------------------------------------------------------
!     /*   box force                                                  */
!-----------------------------------------------------------------------

      factor(:,:) = volume * pres(:,:)

      do l = 1, 3
      do k = 1, 3
      do j = 1, 3
      do i = 1, 3
         factor(i,j) = factor(i,j) &
     &               - volume_ref*box(i,k)*sigma_ref(k,l)*box(j,l)
      end do
      end do
      end do
      end do

      factor(1,1) = factor(1,1) + cmtk / dble(3.d0*natom) * 2.d0*dkin
      factor(2,2) = factor(2,2) + cmtk / dble(3.d0*natom) * 2.d0*dkin
      factor(3,3) = factor(3,3) + cmtk / dble(3.d0*natom) * 2.d0*dkin

!-----------------------------------------------------------------------
!     /*   update logarithm of box velocity                           */
!-----------------------------------------------------------------------

      vbox(:,:) = vbox(:,:) + factor(:,:) / boxmass(:,:) * 0.5d0*dt

!-----------------------------------------------------------------------
!     /*   apply rotational correction                                */
!-----------------------------------------------------------------------

      do i = 1, 3
      do j = i, 3
         vbox(i,j) = 0.5d0 * ( vbox(j,i) + vbox(i,j) )
         vbox(j,i) = vbox(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   box velocity                                               */
!-----------------------------------------------------------------------

      boxdot(:,:) = 0.d0

      do k = 1, 3
      do j = 1, 3
      do i = 1, 3
         boxdot(i,j) = boxdot(i,j) + vbox(i,k)*box(k,j)
      end do
      end do
      end do

      return
      end

