!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_XMPI
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux, fuy, fuz, dt, fictmass

      use XMPI_variables, only : &
     &   jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = jstart_bead, jend_bead
      do i = jstart_atom, jend_atom
         vux(i,j) = vux(i,j) + 0.5d0*dt*fux(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*dt*fuy(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*dt*fuz(i,j)/fictmass(i,j)
      end do
      end do

      return
      end




!***********************************************************************
      subroutine update_vel_ref_XMPI
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by reference (harmonic) forces.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, dt_ref, fux_ref, fuy_ref, fuz_ref, fictmass

      use XMPI_variables, only : &
     &   jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = jstart_bead, jend_bead
      do i = jstart_atom, jend_atom
         vux(i,j) = vux(i,j) + 0.5d0*dt_ref*fux_ref(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*dt_ref*fuy_ref(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*dt_ref*fuz_ref(i,j)/fictmass(i,j)
      end do
      end do

      return
      end
