!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update velocities
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux, fuy, fuz, dt, fictmass, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*dt*fux(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*dt*fuy(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*dt*fuz(i,j)/fictmass(i,j)

      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_ref
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by reference (harmonic) forces.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, dt_ref, fux_ref, fuy_ref, fuz_ref, &
     &   fictmass, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*dt_ref*fux_ref(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*dt_ref*fuy_ref(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*dt_ref*fuz_ref(i,j)/fictmass(i,j)
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_gillespie
!***********************************************************************
!=======================================================================
!
!     update normal mode velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux, fuy, fuz, ux, uy, uz, dt, fictmass, &
     &   dt, tau_bcmd, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

      real(8) :: g1

!-----------------------------------------------------------------------
!     /*   centroid                                                   */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*dt*fux(i,j)/fictmass(i,j)
         vuy(i,j) = vuy(i,j) + 0.5d0*dt*fuy(i,j)/fictmass(i,j)
         vuz(i,j) = vuz(i,j) + 0.5d0*dt*fuz(i,j)/fictmass(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   non-centroid                                               */
!-----------------------------------------------------------------------

      g1 = ( 1.d0 - exp(-dt/tau_bcmd) ) / dt

      do j = 2, nbead
      do i = 1, natom

         vux(i,j) = vux(i,j) - ux(i,j) * g1
         vuy(i,j) = vuy(i,j) - uy(i,j) * g1
         vuz(i,j) = vuz(i,j) - uz(i,j) * g1

      end do
      end do

      return
      end
