!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update positions and velocities in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_sys_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, natom, nbead

      use tass_variables, only : &
     &   dt_ref_tass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         ux(i,j) = ux(i,j) + vux(i,j)*dt_ref_tass
         uy(i,j) = uy(i,j) + vuy(i,j)*dt_ref_tass
         uz(i,j) = uz(i,j) + vuz(i,j)*dt_ref_tass
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_bead

      return
      end





!***********************************************************************
      subroutine update_vel_sys_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux, fuy, fuz, fictmass, dt, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*fux(i,j)/fictmass(i,j)*dt
         vuy(i,j) = vuy(i,j) + 0.5d0*fuy(i,j)/fictmass(i,j)*dt
         vuz(i,j) = vuz(i,j) + 0.5d0*fuz(i,j)/fictmass(i,j)*dt
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_sys_ref_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux_ref, fuy_ref, fuz_ref, fictmass, &
     &   natom, nbead

      use tass_variables, only : &
     &   dt_ref_tass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) &
     &            + 0.5d0*fux_ref(i,j)/fictmass(i,j)*dt_ref_tass
         vuy(i,j) = vuy(i,j) &
     &            + 0.5d0*fuy_ref(i,j)/fictmass(i,j)*dt_ref_tass
         vuz(i,j) = vuz(i,j) &
     &            + 0.5d0*fuz_ref(i,j)/fictmass(i,j)*dt_ref_tass
      end do
      end do

      return
      end
