!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update positions and velocities
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_sys_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, dt, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         ux(i,j) = ux(i,j) + vux(i,j)*dt
         uy(i,j) = uy(i,j) + vuy(i,j)*dt
         uz(i,j) = uz(i,j) + vuz(i,j)*dt
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_bead

      return
      end





!***********************************************************************
      subroutine update_vel_sys_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, fux, fuy, fuz, fictmass, dt, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vux(i,j) = vux(i,j) + 0.5d0*fux(i,j)/fictmass(i,j)*dt
         vuy(i,j) = vuy(i,j) + 0.5d0*fuy(i,j)/fictmass(i,j)*dt
         vuz(i,j) = vuz(i,j) + 0.5d0*fuz(i,j)/fictmass(i,j)*dt
      end do
      end do

      return
      end
