!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update positions in string method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_string
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, fictmass, dt, natom, nbead, ends_string

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   real numbers   */
      real(8) :: dx, dy, dz, sum, fxi, fyi, fzi

!     /*   integers   */
      integer :: i, j, l, m

!-----------------------------------------------------------------------
!     /*   trial update of beads using euler method                   */
!-----------------------------------------------------------------------

      l = 1
      m = nbead

      if ( ends_string(1:5)  .eq. 'FREE '      ) l = 1
      if ( ends_string(1:6)  .eq. 'FIXED '     ) l = 2
      if ( ends_string(1:10) .eq. 'FREEFIXED ' ) l = 1
      if ( ends_string(1:10) .eq. 'FIXEDFREE ' ) l = 2

      if ( ends_string(1:5)  .eq. 'FREE '      ) m = nbead
      if ( ends_string(1:6)  .eq. 'FIXED '     ) m = nbead-1
      if ( ends_string(1:10) .eq. 'FREEFIXED ' ) m = nbead-1
      if ( ends_string(1:10) .eq. 'FIXEDFREE ' ) m = nbead

      do j = l, m

         sum = 0.d0

         do i = 1, natom

            fxi = fx(i,j) * dble(nbead)
            fyi = fy(i,j) * dble(nbead)
            fzi = fz(i,j) * dble(nbead)

            sum = sum + fxi * fxi / fictmass(i,1)
            sum = sum + fyi * fyi / fictmass(i,1)
            sum = sum + fzi * fzi / fictmass(i,1)

         end do

         sum = sqrt(sum)

         if ( sum .eq. 0.d0 ) cycle

         do i = 1, natom

            fxi = fx(i,j) * dble(nbead)
            fyi = fy(i,j) * dble(nbead)
            fzi = fz(i,j) * dble(nbead)

            dx = fxi / fictmass(i,1) / sum
            dy = fyi / fictmass(i,1) / sum
            dz = fzi / fictmass(i,1) / sum

            x(i,j) = x(i,j) + dx * dt
            y(i,j) = y(i,j) + dy * dt
            z(i,j) = z(i,j) + dz * dt

         end do

      end do

      return
      end
