!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     backup in replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_remc
!***********************************************************************
!=======================================================================
!
!     atom exchange
!
!=======================================================================

!-----------------------------------------------------------------------
!     //   shared variables
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, natom, nbead, ikind, iounit

      use rehmc_variables, only : &
     &   x_save, y_save, z_save, iatom_mc, jatom_mc

!-----------------------------------------------------------------------
!     //   local variables
!-----------------------------------------------------------------------

      implicit none

      integer, parameter :: int_huge = 100000

      real(8) :: ranf1, randomno

      integer :: i, j, k, m, ij, ierr

!-----------------------------------------------------------------------
!     //   trial move: random switch of atoms i and j of different kind
!-----------------------------------------------------------------------

!     //   error flag
      ierr = 0

!     //   contant
      ij = jatom_mc - iatom_mc + 1

!     //   loop of replicas
      do m = 1, nbead

!        //   counter
         k = 0

!        /*   uniform random number   */
         randomno = ranf1()

!        //   random integer from l to n
         i = int( randomno * dble(ij) ) + iatom_mc

!        //   make sure in the range
         i = min( max(i,1), natom )

!        //   attempts
         do

!           /*   uniform random number   */
            randomno = ranf1()

!           //   random integer from l to n
            j = int( randomno * dble(ij) ) + iatom_mc

!           //   make sure in the range
            j = min( max(j,1), natom )

!           //   atom kinds must be different
            if ( ikind(i) .ne. ikind(j) ) exit

!           //   counter
            k = k + 1

!           //   error detection
            if ( k .gt. int_huge ) then
               ierr = 1
               exit
            end if

!        //   attempts
         end do

!        //   error detection
         if ( ierr .ne. 0 ) exit

!        //   exchange position i and j
         x(j,m) = x_save(i,m)
         y(j,m) = y_save(i,m)
         z(j,m) = z_save(i,m)

!        //   exchange position i and j
         x(i,m) = x_save(j,m)
         y(i,m) = y_save(j,m)
         z(i,m) = z_save(j,m)

!     //   loop of replicas
      end do

!-----------------------------------------------------------------------
!     /*   error termination                                          */
!-----------------------------------------------------------------------

      call error_handling( ierr, 'subroutine update_remc', 22 )

      return
      end





!***********************************************************************
      subroutine update_remc_sub
!***********************************************************************
!=======================================================================
!
!     atom exchange for dual potential
!
!=======================================================================

!-----------------------------------------------------------------------
!     //   shared variables
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, pot, natom, nbead, ikind, iounit

      use rehmc_variables, only : &
     &   x_sub_save, y_sub_save, z_sub_save, pot_sub_save, &
     &   iatom_mc, jatom_mc

!-----------------------------------------------------------------------
!     //   local variables
!-----------------------------------------------------------------------

      implicit none

      integer, parameter :: int_huge = 100000

      real(8) :: ranf1, randomno

      integer :: i, j, k, m, ij, ierr

!-----------------------------------------------------------------------
!     //   save
!-----------------------------------------------------------------------

!     //   old coordinates
      x_sub_save(:,:) = x(:,:)
      y_sub_save(:,:) = y(:,:)
      z_sub_save(:,:) = z(:,:)

!     //   old potential
      pot_sub_save(:) = pot(:)

!-----------------------------------------------------------------------
!     //   trial move: random switch of atoms i and j of different kind
!-----------------------------------------------------------------------

!     //   error flag
      ierr = 0

!     //   contant
      ij = jatom_mc - iatom_mc + 1

!     //   loop of replicas
      do m = 1, nbead

!        //   counter
         k = 0

!        /*   uniform random number   */
         randomno = ranf1()

!        //   random integer from l to n
         i = int( randomno * dble(ij) ) + iatom_mc

!        //   make sure in the range
         i = min( max(i,1), natom )

!        //   attempts
         do

!           /*   uniform random number   */
            randomno = ranf1()

!           //   random integer from l to n
            j = int( randomno * dble(ij) ) + iatom_mc

!           //   make sure in the range
            j = min( max(j,1), natom )

!           //   atom kinds must be different
            if ( ikind(i) .ne. ikind(j) ) exit

!           //   counter
            k = k + 1

!           //   error detection
            if ( k .gt. int_huge ) then
               ierr = 1
               exit
            end if

!        //   attempts
         end do

!        //   error detection
         if ( ierr .ne. 0 ) exit

!        //   exchange position i and j
         x(j,m) = x_sub_save(i,m)
         y(j,m) = y_sub_save(i,m)
         z(j,m) = z_sub_save(i,m)

!        //   exchange position i and j
         x(i,m) = x_sub_save(j,m)
         y(i,m) = y_sub_save(j,m)
         z(i,m) = z_sub_save(j,m)

!     //   loop of replicas
      end do

!-----------------------------------------------------------------------
!     /*   error termination                                          */
!-----------------------------------------------------------------------

      call error_handling( ierr, 'subroutine update_remc_sub', 25 )

      return
      end
