!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update positions and velocities
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_vel_xyz_rehmc
!***********************************************************************
!=======================================================================
!
!     update cartesian velocities by interatomic forces
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vx, vy, vz, dt, fx, fy, fz, physmass, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vx(i,j) = vx(i,j) + 0.5d0*dt*fx(i,j)/physmass(i)
         vy(i,j) = vy(i,j) + 0.5d0*dt*fy(i,j)/physmass(i)
         vz(i,j) = vz(i,j) + 0.5d0*dt*fz(i,j)/physmass(i)
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_pos_xyz_rehmc
!***********************************************************************
!=======================================================================
!
!     update cartesian coordinates.
!
!=======================================================================

      use common_variables, only : &
     &   x, y, z, dt, vx, vy, vz, ux, uy, uz, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         x(i,j) = x(i,j) + dt*vx(i,j)
         y(i,j) = y(i,j) + dt*vy(i,j)
         z(i,j) = z(i,j) + dt*vz(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_xyz

!-----------------------------------------------------------------------
!     /*   copy geometry                                              */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         ux(i,j) = x(i,j)
         uy(i,j) = y(i,j)
         uz(i,j) = z(i,j)
      end do
      end do

      return
      end
