!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_posvel_anal_XMPI
!***********************************************************************
!=======================================================================
!
!     update normal mode coordinates.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, ux, uy, uz, dnmmass, fictmass, omega_p, dt

      use XMPI_variables, only : &
     &   jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: omega0, ux0, uy0, uz0, vux0, vuy0, vuz0, cos0, sin0

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = jstart_bead, jend_bead

         if ( j .eq. 1 ) then

            do i = jstart_atom, jend_atom
               ux(i,j) = ux(i,j) + vux(i,j)*dt
               uy(i,j) = uy(i,j) + vuy(i,j)*dt
               uz(i,j) = uz(i,j) + vuz(i,j)*dt
            end do

         else

            do i = jstart_atom, jend_atom

               omega0 = sqrt(dnmmass(i,j)/fictmass(i,j))*omega_p

               ux0  = ux(i,j)
               uy0  = uy(i,j)
               uz0  = uz(i,j)

               vux0 = vux(i,j)
               vuy0 = vuy(i,j)
               vuz0 = vuz(i,j)

               cos0 = cos(omega0*dt)
               sin0 = sin(omega0*dt)

               ux(i,j)  =  ux0*cos0 + vux0/omega0*sin0
               uy(i,j)  =  uy0*cos0 + vuy0/omega0*sin0
               uz(i,j)  =  uz0*cos0 + vuz0/omega0*sin0

               vux(i,j) = vux0*cos0 -  ux0*omega0*sin0
               vuy(i,j) = vuy0*cos0 -  uy0*omega0*sin0
               vuz(i,j) = vuz0*cos0 -  uz0*omega0*sin0

            end do

         end if

      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent_XMPI

      return
      end
