!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     analytical updates of position and velocity
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_posvel_anal
!***********************************************************************
!=======================================================================
!
!     update normal mode coordinates.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, dnmmass, fictmass, omega_p, dt, &
     &   natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j
      real(8) :: omega0, ux0, uy0, uz0, vux0, vuy0, vuz0, cos0, sin0

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   for centroid   */

      do i = 1, natom
         ux(i,1) = ux(i,1) + vux(i,1)*dt
         uy(i,1) = uy(i,1) + vuy(i,1)*dt
         uz(i,1) = uz(i,1) + vuz(i,1)*dt
      end do

!     /*   for non-centroid   */

      do j = 2, nbead
      do i = 1, natom

         omega0 = sqrt(dnmmass(i,j)/fictmass(i,j))*omega_p

         ux0  = ux(i,j)
         uy0  = uy(i,j)
         uz0  = uz(i,j)

         vux0 = vux(i,j)
         vuy0 = vuy(i,j)
         vuz0 = vuz(i,j)

         cos0 = cos(omega0*dt)
         sin0 = sin(omega0*dt)

         ux(i,j)  =  ux0*cos0 + vux0/omega0*sin0
         uy(i,j)  =  uy0*cos0 + vuy0/omega0*sin0
         uz(i,j)  =  uz0*cos0 + vuz0/omega0*sin0

         vux(i,j) = vux0*cos0 -  ux0*omega0*sin0
         vuy(i,j) = vuy0*cos0 -  uy0*omega0*sin0
         vuz(i,j) = vuz0*cos0 -  uz0*omega0*sin0

      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent

      return
      end
