!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update Cartesian position and velocity
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_xyz_MPI
!***********************************************************************
!=======================================================================
!
!     update cartesian coordinates.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, vx, vy, vz, dt_ref, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         x(i,j) = x(i,j) + dt_ref*vx(i,j)
         y(i,j) = y(i,j) + dt_ref*vy(i,j)
         z(i,j) = z(i,j) + dt_ref*vz(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_xyz

!-----------------------------------------------------------------------
!     /*   Cartesian position -> normal mode position                 */
!-----------------------------------------------------------------------

      call nm_trans_MPI(1)

      return
      end

