!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update coordinates in multiple time scale method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_multi_me_p ( ds_ref )
!***********************************************************************
!=======================================================================
!
!     update normal mode coordinates.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, natom, nbead

      use qmmm_variables, only : &
     &   layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: ds_ref

!-----------------------------------------------------------------------
!     /*   update                                                     */
!-----------------------------------------------------------------------

      do i = 1, natom
         if ( layer(i)(1:1) .ne. 'A' ) cycle
         do j = 1, nbead
            ux(i,j) = ux(i,j) + ds_ref*vux(i,j)
            uy(i,j) = uy(i,j) + ds_ref*vuy(i,j)
            uz(i,j) = uz(i,j) + ds_ref*vuz(i,j)
         end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent

      return
      end





!***********************************************************************
      subroutine update_pos_multi_me_s ( ds_ref )
!***********************************************************************
!=======================================================================
!
!     update normal mode coordinates.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, natom, nbead

      use qmmm_variables, only : &
     &   layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: ds_ref

!-----------------------------------------------------------------------
!     /*   update                                                     */
!-----------------------------------------------------------------------

      do i = 1, natom
         if ( layer(i)(1:1) .ne. 'B' ) cycle
         do j = 1, nbead
            ux(i,j) = ux(i,j) + ds_ref*vux(i,j)
            uy(i,j) = uy(i,j) + ds_ref*vuy(i,j)
            uz(i,j) = uz(i,j) + ds_ref*vuz(i,j)
         end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent

      return
      end
