!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update positions in molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, vx, vy, vz, ux, uy, uz, dt, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

!-----------------------------------------------------------------------
!     /*   update position                                            */
!-----------------------------------------------------------------------

      do l = 1, nbead
      do k = 1, natom
         x(k,l) = x(k,l) + vx(k,l)*dt
         y(k,l) = y(k,l) + vy(k,l)*dt
         z(k,l) = z(k,l) + vz(k,l)*dt
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_xyz

!-----------------------------------------------------------------------
!     /*   save position                                              */
!-----------------------------------------------------------------------

      ux(:,:) = x(:,:)
      uy(:,:) = y(:,:)
      uz(:,:) = z(:,:)

      return
      end
