!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update box positions in NtH ensemble
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_box_nth_pp_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   volume, vbox, dt_ref, box, boxinv, gbox, strain, boxinv_ref, &
     &   sigma_ref, volume_ref, stress

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l

      real(8) :: b(3,3), a(3,3), e(3), factor, det3

!-----------------------------------------------------------------------
!     /*   diagonalize box velocity                                   */
!-----------------------------------------------------------------------

      call ddiag_MPI ( vbox, e, b, 3 )

!-----------------------------------------------------------------------
!     /*   transform matrix                                           */
!-----------------------------------------------------------------------

      a(:,:) = 0.d0

      do k = 1, 3

         factor = exp( e(k)*0.5d0*dt_ref )

         do j = 1, 3
         do i = 1, 3
            a(i,j) = a(i,j) + b(i,k) * factor * b(j,k)
         end do
         end do

      end do

!-----------------------------------------------------------------------
!     /*   update box due to box transform                            */
!-----------------------------------------------------------------------

      b(1,:) = a(1,1)*box(1,:) + a(1,2)*box(2,:) + a(1,3)*box(3,:)
      b(2,:) = a(2,1)*box(1,:) + a(2,2)*box(2,:) + a(2,3)*box(3,:)
      b(3,:) = a(3,1)*box(1,:) + a(3,2)*box(2,:) + a(3,3)*box(3,:)

      box(:,:) = b(:,:)

!-----------------------------------------------------------------------
!     /*   update volume                                              */
!-----------------------------------------------------------------------

      volume = det3( box )

!-----------------------------------------------------------------------
!     /*   inverse matrix of cell matrix                              */
!-----------------------------------------------------------------------

      call inv3 ( box, boxinv )

!-----------------------------------------------------------------------
!     /*   metric matrix                                              */
!-----------------------------------------------------------------------

      gbox(:,:) = 0.d0

      do k = 1, 3
      do j = 1, 3
      do i = 1, 3
         gbox(i,j) = gbox(i,j) + box(k,i)*box(k,j)
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   strain matrix                                              */
!-----------------------------------------------------------------------

      strain(:,:) = 0.d0

      do l = 1, 3
      do k = 1, 3
      do j = 1, 3
      do i = 1, 3

         strain(i,j) = strain(i,j) &
     &               + boxinv_ref(k,i)*gbox(k,l)*boxinv_ref(l,j)

      end do
      end do
      end do
      end do

      do i = 1, 3
         strain(i,i) = strain(i,i) - 1.d0
      end do

      strain(:,:) = 0.5d0*strain(:,:)

!-----------------------------------------------------------------------
!     /*   stress matrix                                              */
!-----------------------------------------------------------------------

      stress(:,:) = 0.d0

      do l = 1, 3
      do k = 1, 3
      do j = 1, 3
      do i = 1, 3

         stress(i,j) = stress(i,j) + box(i,k)*sigma_ref(k,l)*box(j,l)

      end do
      end do
      end do
      end do

      stress(:,:) = stress(:,:) * volume_ref / volume

      return
      end

