!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_XMPI
!***********************************************************************
!-----------------------------------------------------------------------
!
!     update normal mode coordinates.
!
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, dt_ref

      use XMPI_variables, only : &
     &   jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = jstart_bead, jend_bead
      do i = jstart_atom, jend_atom
         ux(i,j) = ux(i,j) + dt_ref*vux(i,j)
         uy(i,j) = uy(i,j) + dt_ref*vuy(i,j)
         uz(i,j) = uz(i,j) + dt_ref*vuz(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent_XMPI

      return
      end
