!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update positions in path integrals
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos
!***********************************************************************
!-----------------------------------------------------------------------
!
!     update normal mode coordinates.
!
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, dt_ref, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         ux(i,j) = ux(i,j) + dt_ref*vux(i,j)
         uy(i,j) = uy(i,j) + dt_ref*vuy(i,j)
         uz(i,j) = uz(i,j) + dt_ref*vuz(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent

      return
      end





!***********************************************************************
      subroutine update_pos_gillespie
!***********************************************************************
!-----------------------------------------------------------------------
!
!     update normal mode coordinates.
!
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, dt, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         ux(i,j) = ux(i,j) + dt*vux(i,j)
         uy(i,j) = uy(i,j) + dt*vuy(i,j)
         uz(i,j) = uz(i,j) + dt*vuz(i,j)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      call pbc_cent

      return
      end
