!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     polymers update positions
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_polymers_atom_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : physmass, natom

      use polymers_variables, only : xc_poly, yc_poly, zc_poly, &
     &    fxc_poly, fyc_poly, fzc_poly, dt_poly, ends_poly, npoly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   real numbers   */
      real(8) :: dx, dy, dz, sum

!     /*   integers   */
      integer :: i, j, jpoly_start, jpoly_end

!-----------------------------------------------------------------------
!     /*   trial update of polymer using euler method                 */
!-----------------------------------------------------------------------

      jpoly_start = 1
      jpoly_end   = npoly

      if ( ends_poly(1:5)  .eq. 'FIXED ' )     jpoly_start = 2
      if ( ends_poly(1:10) .eq. 'FIXEDFREE ' ) jpoly_start = 2
      if ( ends_poly(1:5)  .eq. 'FIXED ' )     jpoly_end   = npoly - 1
      if ( ends_poly(1:10) .eq. 'FREEFIXED ' ) jpoly_end   = npoly - 1

      do j = jpoly_start, jpoly_end

         sum = 0.d0

         do i = 1, natom

            sum = sum + fxc_poly(i,j) * fxc_poly(i,j) / physmass(i)
            sum = sum + fyc_poly(i,j) * fyc_poly(i,j) / physmass(i)
            sum = sum + fzc_poly(i,j) * fzc_poly(i,j) / physmass(i)

         end do

         sum = sqrt(sum)

         if ( sum .eq. 0.d0 ) cycle

         do i = 1, natom

            dx = fxc_poly(i,j) / physmass(i) / sum
            dy = fyc_poly(i,j) / physmass(i) / sum
            dz = fzc_poly(i,j) / physmass(i) / sum

            xc_poly(i,j) = xc_poly(i,j) + dx*dt_poly
            yc_poly(i,j) = yc_poly(i,j) + dy*dt_poly
            zc_poly(i,j) = zc_poly(i,j) + dz*dt_poly

         end do

      end do

      return
      end





!***********************************************************************
      subroutine update_polymers_cons_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons
      use afed_variables, only : fictmass_afed

      use polymers_variables, only : &
     &   rcons_poly, fcons_poly, dt_poly, ends_poly, npoly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   real numbers   */
      real(8) :: sum

!     /*   integers   */
      integer :: i, j, jpoly_start, jpoly_end

!-----------------------------------------------------------------------
!     /*   trial update of polymer using euler method                 */
!-----------------------------------------------------------------------

      jpoly_start = 1
      jpoly_end   = npoly

      if ( ends_poly(1:5)  .eq. 'FIXED ' )     jpoly_start = 2
      if ( ends_poly(1:10) .eq. 'FIXEDFREE ' ) jpoly_start = 2
      if ( ends_poly(1:5)  .eq. 'FIXED ' )     jpoly_end   = npoly - 1
      if ( ends_poly(1:10) .eq. 'FREEFIXED ' ) jpoly_end   = npoly - 1

      do j = jpoly_start, jpoly_end

         sum = 0.d0

         do i = 1, ncons

            sum = sum &
     &          + fcons_poly(i,j) * fcons_poly(i,j) / fictmass_afed(i)

         end do

         sum = sqrt(sum)

         if ( sum .eq. 0.d0 ) cycle

         do i = 1, ncons

            rcons_poly(i,j) = rcons_poly(i,j) &
     &         + ( fcons_poly(i,j) / fictmass_afed(i) / sum ) * dt_poly

         end do

      end do

      return
      end
