!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     brownian chain molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pibcmd_platen_MPI( ioption )
!***********************************************************************
!-----------------------------------------------------------------------
!    //   shared variables
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, fux, fuy, fuz, fux_ref, fuy_ref, fuz_ref, fictmass, &
     &   ux, uy, uz, fxp, fyp, fzp, fxm, fym, fzm, omega_p2, &
     &   potential, dnmmass, hamiltonian_cor, natom, nbead

!-----------------------------------------------------------------------
!    //   local variables
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, i, j
      real(8) :: factor, epot, epot_cor
      integer, save :: iset = 0

!      real(8) :: dux(natom,nbead), duy(natom,nbead), duz(natom,nbead)
!      real(8) :: epot_2, df, du

!-----------------------------------------------------------------------
!    //   memory allocation
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         if ( .not. allocated(fxp) ) allocate( fxp(natom,nbead) )
         if ( .not. allocated(fyp) ) allocate( fyp(natom,nbead) )
         if ( .not. allocated(fzp) ) allocate( fzp(natom,nbead) )

         if ( .not. allocated(fxm) ) allocate( fxm(natom,nbead) )
         if ( .not. allocated(fym) ) allocate( fym(natom,nbead) )
         if ( .not. allocated(fzm) ) allocate( fzm(natom,nbead) )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     //   initial step: save old forces
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         fxp(:,:) = fux(:,:) + fux_ref(:,:)
         fyp(:,:) = fuy(:,:) + fuy_ref(:,:)
         fzp(:,:) = fuz(:,:) + fuz_ref(:,:)

      end if

!-----------------------------------------------------------------------
!     //   continued step
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

!-----------------------------------------------------------------------
!        //   save intermediate forces
!-----------------------------------------------------------------------

         do j = 1, nbead
         do i = 1, natom
            fxm(i,j) = fux(i,j) + fux_ref(i,j)
            fym(i,j) = fuy(i,j) + fuy_ref(i,j)
            fzm(i,j) = fuz(i,j) + fuz_ref(i,j)
         end do
         end do

!-----------------------------------------------------------------------
!        //   intermediate effective potential
!-----------------------------------------------------------------------

         epot = potential

         do j = 2, nbead
         do i = 1, natom
            factor = 0.5d0 * dnmmass(i,j) * omega_p2
            epot = epot &
     &         + factor * ux(i,j) * ux(i,j) &
     &         + factor * uy(i,j) * uy(i,j) &
     &         + factor * uz(i,j) * uz(i,j)
         end do
         end do

         epot_cor = - epot

!-----------------------------------------------------------------------
!        //   shift from intermediate to final
!-----------------------------------------------------------------------

         do j = 1, nbead
         do i = 1, natom

            factor = 0.25d0*dt*dt / fictmass(i,j)

!            dux(i,j) = ( fxm(i,j) - fxp(i,j) ) * factor
!            duy(i,j) = ( fym(i,j) - fyp(i,j) ) * factor
!            duz(i,j) = ( fzm(i,j) - fzp(i,j) ) * factor
!
!            ux(i,j) = ux(i,j) + dux(i,j)
!            uy(i,j) = uy(i,j) + duy(i,j)
!            uz(i,j) = uz(i,j) + duz(i,j)

            ux(i,j) = ux(i,j) + ( fxm(i,j) - fxp(i,j) ) * factor
            uy(i,j) = uy(i,j) + ( fym(i,j) - fyp(i,j) ) * factor
            uz(i,j) = uz(i,j) + ( fzm(i,j) - fzp(i,j) ) * factor

         end do
         end do

!-----------------------------------------------------------------------
!        //   normal mode positions to cartesian positions
!-----------------------------------------------------------------------

         call nm_trans_MPI( 0 )

!-----------------------------------------------------------------------
!        //   final physical forces
!-----------------------------------------------------------------------

         call getforce_MPI

!-----------------------------------------------------------------------
!        //   cartesian forces to normal mode forces
!-----------------------------------------------------------------------

         call nm_trans_force_MPI( 1 )

!-----------------------------------------------------------------------
!        //   final bead spring forces
!-----------------------------------------------------------------------

         call getforce_ref

!-----------------------------------------------------------------------
!        //   save old forces
!-----------------------------------------------------------------------

         fxp(:,:) = fux(:,:) + fux_ref(:,:)
         fyp(:,:) = fuy(:,:) + fuy_ref(:,:)
         fzp(:,:) = fuz(:,:) + fuz_ref(:,:)

!-----------------------------------------------------------------------
!        //   final effective potential
!-----------------------------------------------------------------------

         epot = potential

         do j = 2, nbead
         do i = 1, natom
            factor = 0.5d0 * dnmmass(i,j) * omega_p2
            epot = epot + factor * ux(i,j) * ux(i,j) &
     &                  + factor * uy(i,j) * uy(i,j) &
     &                  + factor * uz(i,j) * uz(i,j)
         end do
         end do

!-----------------------------------------------------------------------
!        //   correction term in platen method
!-----------------------------------------------------------------------

!         df = 0.d0
!
!         do j = 1, nbead
!         do i = 1, natom
!            df = df + fxp(i,j) - fxm(i,j)
!            df = df + fyp(i,j) - fym(i,j)
!            df = df + fzp(i,j) - fzm(i,j)
!         end do
!         end do
!
!         du = 0.d0
!
!         do i = 1, nbead
!         do j = 1, natom
!            du = du + dux(j,i)
!            du = du + duy(j,i)
!            du = du + duz(j,i)
!         end do
!         end do
!
!         epot_2 = - 0.5d0*df*du

!-----------------------------------------------------------------------
!        //   energy shift in this step
!-----------------------------------------------------------------------

         epot_cor = epot_cor + epot

!-----------------------------------------------------------------------
!        //   accumulated energy shift in the trajectory
!-----------------------------------------------------------------------

         hamiltonian_cor = hamiltonian_cor - epot_cor

      end if

!-----------------------------------------------------------------------
!        //   back to main loop
!-----------------------------------------------------------------------

      return
      end
