!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update in Onsager-Machlup action optimization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_omopt_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use om_variables, only : &
     &    fux_om, fuy_om, fuz_om, fux_ref_om, fuy_ref_om, fuz_ref_om

      use common_variables, only : &
     &    ux, uy, uz, natom, nbead, iexit, iounit

      use om_variables, only : &
     &    action_om, action_ref_om

      use lbfgs_variables, only : &
     &    pos, pos0, grad, func, dm, eps, postol, ws, &
     &    drms, dmax, fmax, frms, drms_tol, dmax_tol, fmax_tol, &
     &    frms_tol, iflag, ndim, nup, iprint

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integers   */
      integer :: i, j, k

!     /*   real numbers   */
      real(8) :: posx, posy, posz

!-----------------------------------------------------------------------
!     /*   trial update of beads using lbfgs method                   */
!-----------------------------------------------------------------------

!     //   lbfgs option
      iprint(1) = 0

!     //   save position, function, gradient
      func = action_om + action_ref_om

      k = 0

      do j = 2, nbead-1
      do i = 1, natom

         k = k + 1

         pos(k)  = ux(i,j)
         grad(k) = - fux_om(i,j) - fux_ref_om(i,j)

         k = k + 1

         pos(k)  = uy(i,j)
         grad(k) = - fuy_om(i,j) - fuy_ref_om(i,j)

         k = k + 1

         pos(k)  = uz(i,j)
         grad(k) = - fuz_om(i,j) - fuz_ref_om(i,j)

      end do
      end do

      pos0(:)  = pos(:)

!     //   lbfgs update

      call lbfgs ( ndim, nup, pos, func, grad, .false., dm, &
     &             iprint, eps, postol, ws, iflag )

!     //   update position

      k = 0

      do j = 2, nbead-1
      do i = 1, natom

         k = k + 1

         ux(i,j) = pos(k)

         k = k + 1

         uy(i,j) = pos(k)

         k = k + 1

         uz(i,j) = pos(k)

      end do
      end do

!-----------------------------------------------------------------------
!     //   check convergence:  root-mean-square of residual force
!-----------------------------------------------------------------------

      frms = 0.d0

      do k = 1, ndim
         frms = frms + grad(k)*grad(k)
      end do

      frms = sqrt(frms)/ndim

!-----------------------------------------------------------------------
!     //   check convergence:  maximum value of residual force
!-----------------------------------------------------------------------

      fmax = 0.d0

      do k = 1, ndim
         fmax = max ( abs( grad(k) ), fmax )
      end do

!-----------------------------------------------------------------------
!     //   check convergence:  root-mean-square of geometrical shift
!-----------------------------------------------------------------------

      drms = 0.d0

      do k = 1, ndim, 3
         posx = pos(k+0) - pos0(k+0)
         posy = pos(k+1) - pos0(k+1)
         posz = pos(k+2) - pos0(k+2)
         call pbc_atom_MPI ( posx, posy, posz )
         drms = drms + posx*posx + posy*posy + posz*posz
      end do

      drms = sqrt(drms)/ndim

!-----------------------------------------------------------------------
!     //   check convergence:  maximum value of geometrical shift
!-----------------------------------------------------------------------

      dmax = 0.d0

      do k = 1, ndim, 3
         posx = pos(k+0) - pos0(k+0)
         posy = pos(k+1) - pos0(k+1)
         posz = pos(k+2) - pos0(k+2)
         call pbc_atom_MPI ( posx, posy, posz )
         dmax = max( abs(posx), dmax )
         dmax = max( abs(posy), dmax )
         dmax = max( abs(posz), dmax )
      end do

!-----------------------------------------------------------------------
!        //   terminate if converged
!-----------------------------------------------------------------------

      if ( ( dmax .lt. dmax_tol ) .and. ( drms .lt. drms_tol ) .and. &
     &     ( fmax .lt. fmax_tol ) .and. ( frms .lt. frms_tol ) ) then
            iflag = 0
      end if

      if ( iflag .eq. 0 ) iexit = 1

      return
      end
