!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update thermostats in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_mnhc_cv_tass
!***********************************************************************
!=======================================================================
!
!     Nose-Hoover chain thermostat attached to collective variables.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ysweight, nys, nbead, ncolor, nnhc

      use tass_variables, only : &
     &   fictmass_tass, qmass_tass, fbath_tass, vbath_tass, &
     &   rbath_tass, vtass, dt_ref_tass, gkt_tass, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m, iys

      real(8) :: scale, dt_ys, vfact, pvfact, dkin

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do iys = 1, nys

!-----------------------------------------------------------------------
!     /*   step size                                                  */
!-----------------------------------------------------------------------

      dt_ys = dt_ref_tass*ysweight(iys) /2.d0

!-----------------------------------------------------------------------
!     /*   massive nhc start                                          */
!-----------------------------------------------------------------------

      do m = 1, nbead
      do k = 1, ncolor
      do j = 1, ntass

!-----------------------------------------------------------------------
!        /*   kinetic energy for each collective variable             */
!-----------------------------------------------------------------------

         dkin = fictmass_tass(j)*vtass(j,m)*vtass(j,m)

         scale = 1.d0

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_tass(j,1,k,m) = ( dkin - gkt_tass ) / qmass_tass(k)

         do i = 2, nnhc
            fbath_tass(j,i,k,m) &
     &        = ( qmass_tass(k) * vbath_tass(j,i-1,k,m) &
     &          * vbath_tass(j,i-1,k,m) - gkt_tass ) / qmass_tass(k)
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         vbath_tass(j,nnhc,k,m) = vbath_tass(j,nnhc,k,m) &
     &                    + 0.25d0*fbath_tass(j,nnhc,k,m)*dt_ys

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_tass(j,nnhc-i+1,k,m)*dt_ys)

            vbath_tass(j,nnhc-i,k,m) &
     &         = vbath_tass(j,nnhc-i,k,m)*vfact*vfact &
     &         + 0.25d0*fbath_tass(j,nnhc-i,k,m)*vfact*dt_ys

         end do

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         pvfact = exp(-0.5d0*vbath_tass(j,1,k,m)*dt_ys)

         scale = scale*pvfact

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_tass(j,1,k,m) &
     &      = ( scale*scale*dkin - gkt_tass ) / qmass_tass(k)

!-----------------------------------------------------------------------
!        /*   update thermostat positions                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc
            rbath_tass(j,i,k,m) = rbath_tass(j,i,k,m) &
     &                        + 0.5d0*vbath_tass(j,i,k,m)*dt_ys
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_tass(j,i+1,k,m)*dt_ys)

            vbath_tass(j,i,k,m) = vbath_tass(j,i,k,m)*vfact*vfact &
     &                    + 0.25d0*fbath_tass(j,i,k,m)*vfact*dt_ys

            fbath_tass(j,i+1,k,m) &
     &         = ( qmass_tass(k) * vbath_tass(j,i,k,m) &
     &         * vbath_tass(j,i,k,m) - gkt_tass ) / qmass_tass(k)

         end do

         vbath_tass(j,nnhc,k,m) = vbath_tass(j,nnhc,k,m) &
     &      + 0.25d0*fbath_tass(j,nnhc,k,m)*dt_ys

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         vtass(j,m) = vtass(j,m)*scale

!-----------------------------------------------------------------------
!     /*   massive nhc end                                            */
!-----------------------------------------------------------------------

      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   massive nhc start                                          */
!-----------------------------------------------------------------------

      do m = nbead, 1, -1
      do k = ncolor, 1, -1
      do j = ntass, 1, -1

!-----------------------------------------------------------------------
!        /*   kinetic energy for each collective variable             */
!-----------------------------------------------------------------------

         dkin = fictmass_tass(j)*vtass(j,m)*vtass(j,m)

         scale = 1.d0

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_tass(j,1,k,m) = ( dkin - gkt_tass ) / qmass_tass(k)

         do i = 2, nnhc
            fbath_tass(j,i,k,m) &
     &        = ( qmass_tass(k) * vbath_tass(j,i-1,k,m) &
     &          * vbath_tass(j,i-1,k,m) - gkt_tass ) / qmass_tass(k)
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         vbath_tass(j,nnhc,k,m) = vbath_tass(j,nnhc,k,m) &
     &                    + 0.25d0*fbath_tass(j,nnhc,k,m)*dt_ys

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_tass(j,nnhc-i+1,k,m)*dt_ys)

            vbath_tass(j,nnhc-i,k,m) &
     &         = vbath_tass(j,nnhc-i,k,m)*vfact*vfact &
     &         + 0.25d0*fbath_tass(j,nnhc-i,k,m)*vfact*dt_ys

         end do

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         pvfact = exp(-0.5d0*vbath_tass(j,1,k,m)*dt_ys)

         scale = scale*pvfact

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_tass(j,1,k,m) &
     &      = ( scale*scale*dkin - gkt_tass ) / qmass_tass(k)

!-----------------------------------------------------------------------
!        /*   update thermostat positions                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc
            rbath_tass(j,i,k,m) = rbath_tass(j,i,k,m) &
     &                        + 0.5d0*vbath_tass(j,i,k,m)*dt_ys
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_tass(j,i+1,k,m)*dt_ys)

            vbath_tass(j,i,k,m) = vbath_tass(j,i,k,m)*vfact*vfact &
     &                    + 0.25d0*fbath_tass(j,i,k,m)*vfact*dt_ys

            fbath_tass(j,i+1,k,m) &
     &         = ( qmass_tass(k) * vbath_tass(j,i,k,m) &
     &           * vbath_tass(j,i,k,m) - gkt_tass ) / qmass_tass(k)

         end do

         vbath_tass(j,nnhc,k,m) = vbath_tass(j,nnhc,k,m) &
     &      + 0.25d0*fbath_tass(j,nnhc,k,m)*dt_ys

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         vtass(j,m) = vtass(j,m)*scale

!-----------------------------------------------------------------------
!     /*   massive nhc end                                            */
!-----------------------------------------------------------------------

      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   main loop end                                              */
!-----------------------------------------------------------------------

      end do

      return
      end
