!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update thermostats in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_mnhc_cv_meta
!***********************************************************************
!=======================================================================
!
!     Nose-Hoover chain thermostat attached to collective variables.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ysweight, gkt, nys, nbead, ncolor, nnhc

      use meta_variables, only : &
     &   fictmass_meta, qmass_meta, fbath_meta, vbath_meta, &
     &   rbath_meta, vmeta, dt_ref_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, m, iys

      real(8) :: scale, dt_ys, vfact, pvfact, dkin

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do iys = 1, nys

!-----------------------------------------------------------------------
!     /*   step size                                                  */
!-----------------------------------------------------------------------

      dt_ys = dt_ref_meta*ysweight(iys) /2.d0

!-----------------------------------------------------------------------
!     /*   massive nhc start                                          */
!-----------------------------------------------------------------------

      do m = 1, nbead
      do k = 1, ncolor
      do j = 1, nmeta

!-----------------------------------------------------------------------
!        /*   kinetic energy for each collective variable             */
!-----------------------------------------------------------------------

         dkin = fictmass_meta(j)*vmeta(j,m)*vmeta(j,m)

         scale = 1.d0

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_meta(j,1,k,m) = (dkin - gkt)/qmass_meta(k)

         do i = 2, nnhc
            fbath_meta(j,i,k,m) &
     &        = ( qmass_meta(k)*vbath_meta(j,i-1,k,m) &
     &          *vbath_meta(j,i-1,k,m) - gkt ) / qmass_meta(k)
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         vbath_meta(j,nnhc,k,m) = vbath_meta(j,nnhc,k,m) &
     &                    + 0.25d0*fbath_meta(j,nnhc,k,m)*dt_ys

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_meta(j,nnhc-i+1,k,m)*dt_ys)

            vbath_meta(j,nnhc-i,k,m) &
     &         = vbath_meta(j,nnhc-i,k,m)*vfact*vfact &
     &         + 0.25d0*fbath_meta(j,nnhc-i,k,m)*vfact*dt_ys

         end do

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         pvfact = exp(-0.5d0*vbath_meta(j,1,k,m)*dt_ys)

         scale = scale*pvfact

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_meta(j,1,k,m) = (scale*scale*dkin - gkt)/qmass_meta(k)

!-----------------------------------------------------------------------
!        /*   update thermostat positions                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc
            rbath_meta(j,i,k,m) = rbath_meta(j,i,k,m) &
     &                        + 0.5d0*vbath_meta(j,i,k,m)*dt_ys
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_meta(j,i+1,k,m)*dt_ys)

            vbath_meta(j,i,k,m) = vbath_meta(j,i,k,m)*vfact*vfact &
     &                    + 0.25d0*fbath_meta(j,i,k,m)*vfact*dt_ys

            fbath_meta(j,i+1,k,m) &
     &         = (qmass_meta(k)*vbath_meta(j,i,k,m)*vbath_meta(j,i,k,m) &
     &            - gkt)/qmass_meta(k)

         end do

         vbath_meta(j,nnhc,k,m) = vbath_meta(j,nnhc,k,m) &
     &      + 0.25d0*fbath_meta(j,nnhc,k,m)*dt_ys

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         vmeta(j,m) = vmeta(j,m)*scale

!-----------------------------------------------------------------------
!     /*   massive nhc end                                            */
!-----------------------------------------------------------------------

      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   massive nhc start                                          */
!-----------------------------------------------------------------------

      do m = nbead, 1, -1
      do k = ncolor, 1, -1
      do j = nmeta, 1, -1

!-----------------------------------------------------------------------
!        /*   kinetic energy for each collective variable             */
!-----------------------------------------------------------------------

         dkin = fictmass_meta(j)*vmeta(j,m)*vmeta(j,m)

         scale = 1.d0

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_meta(j,1,k,m) = (dkin - gkt)/qmass_meta(k)

         do i = 2, nnhc
            fbath_meta(j,i,k,m) &
     &        = ( qmass_meta(k)*vbath_meta(j,i-1,k,m) &
     &          *vbath_meta(j,i-1,k,m) - gkt ) / qmass_meta(k)
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         vbath_meta(j,nnhc,k,m) = vbath_meta(j,nnhc,k,m) &
     &                    + 0.25d0*fbath_meta(j,nnhc,k,m)*dt_ys

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_meta(j,nnhc-i+1,k,m)*dt_ys)

            vbath_meta(j,nnhc-i,k,m) &
     &         = vbath_meta(j,nnhc-i,k,m)*vfact*vfact &
     &         + 0.25d0*fbath_meta(j,nnhc-i,k,m)*vfact*dt_ys

         end do

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         pvfact = exp(-0.5d0*vbath_meta(j,1,k,m)*dt_ys)

         scale = scale*pvfact

!-----------------------------------------------------------------------
!        /*   update thermostat forces                                */
!-----------------------------------------------------------------------

         fbath_meta(j,1,k,m) = (scale*scale*dkin - gkt)/qmass_meta(k)

!-----------------------------------------------------------------------
!        /*   update thermostat positions                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc
            rbath_meta(j,i,k,m) = rbath_meta(j,i,k,m) &
     &                        + 0.5d0*vbath_meta(j,i,k,m)*dt_ys
         end do

!-----------------------------------------------------------------------
!       /*   update thermostat velocities                             */
!-----------------------------------------------------------------------

         do i = 1, nnhc-1

            vfact = exp(-0.125d0*vbath_meta(j,i+1,k,m)*dt_ys)

            vbath_meta(j,i,k,m) = vbath_meta(j,i,k,m)*vfact*vfact &
     &                    + 0.25d0*fbath_meta(j,i,k,m)*vfact*dt_ys

            fbath_meta(j,i+1,k,m) &
     &         = (qmass_meta(k)*vbath_meta(j,i,k,m)*vbath_meta(j,i,k,m) &
     &            - gkt)/qmass_meta(k)

         end do

         vbath_meta(j,nnhc,k,m) = vbath_meta(j,nnhc,k,m) &
     &      + 0.25d0*fbath_meta(j,nnhc,k,m)*dt_ys

!-----------------------------------------------------------------------
!        /*   update velocity of collective variable                  */
!-----------------------------------------------------------------------

         vmeta(j,m) = vmeta(j,m)*scale

!-----------------------------------------------------------------------
!     /*   massive nhc end                                            */
!-----------------------------------------------------------------------

      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   main loop end                                              */
!-----------------------------------------------------------------------

      end do

      return
      end
