!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update massive Nose-Hoover chain on centroids
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_mnhc_cent_me_p ( ds )
!***********************************************************************
!=======================================================================
!
!     Update Nose-Hoover chain thermostat attached to centroid.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fictmass, vux, vuy, vuz, ysweight, fxbath_cent, fybath_cent, &
     &   fzbath_cent, vxbath_cent, vybath_cent, vzbath_cent, gkt, &
     &   xbath_cent, ybath_cent, zbath_cent, nys, nnhc, ncolor, natom

      use qmmm_variables, only : &
     &   qmass_cent_multi_a, layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, iys, inhc, l

      real(8) :: ds, dt_ys, dkinx, dkiny, dkinz, scalex, scaley, scalez, &
     &           vxfact, vyfact, vzfact, pvxfact, pvyfact, pvzfact

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do iys = 1, nys

!-----------------------------------------------------------------------
!        /*   step size                                               */
!-----------------------------------------------------------------------

         dt_ys = ds*ysweight(iys) /2.d0

!-----------------------------------------------------------------------
!        /*   massive nhc start                                       */
!-----------------------------------------------------------------------

         do l = 1, ncolor
         do j = 1, natom

            if ( layer(j)(1:1) .ne. 'A' ) cycle

!           /*   calculate total kinetic energy of the system   */

            dkinx = fictmass(j,1)*vux(j,1)*vux(j,1)
            dkiny = fictmass(j,1)*vuy(j,1)*vuy(j,1)
            dkinz = fictmass(j,1)*vuz(j,1)*vuz(j,1)

            scalex = 1.d0
            scaley = 1.d0
            scalez = 1.d0

            fxbath_cent(j,1,l) = (dkinx - gkt)/qmass_cent_multi_a(1,l)
            fybath_cent(j,1,l) = (dkiny - gkt)/qmass_cent_multi_a(1,l)
            fzbath_cent(j,1,l) = (dkinz - gkt)/qmass_cent_multi_a(1,l)

            do i = 2, nnhc
              fxbath_cent(j,i,l) = &
     &           (qmass_cent_multi_a(i-1,l)*vxbath_cent(j,i-1,l) &
     &           *vxbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_a(i,l)
              fybath_cent(j,i,l) = &
     &           (qmass_cent_multi_a(i-1,l)*vybath_cent(j,i-1,l) &
     &           *vybath_cent(j,i-1,l) - gkt)/qmass_cent_multi_a(i,l)
              fzbath_cent(j,i,l) = &
     &           (qmass_cent_multi_a(i-1,l)*vzbath_cent(j,i-1,l) &
     &           *vzbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_a(i,l)
            end do

!           /*   update the thermostat velocities   */

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

            do inhc = 1, nnhc-1

               vxfact &
     &            = exp(-0.125d0*vxbath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vyfact &
     &            = exp(-0.125d0*vybath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vzfact &
     &            = exp(-0.125d0*vzbath_cent(j,nnhc-inhc+1,l)*dt_ys)

               vxbath_cent(j,nnhc-inhc,l) = &
     &            vxbath_cent(j,nnhc-inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,nnhc-inhc,l)*vxfact*dt_ys
               vybath_cent(j,nnhc-inhc,l) = &
     &            vybath_cent(j,nnhc-inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,nnhc-inhc,l)*vyfact*dt_ys
               vzbath_cent(j,nnhc-inhc,l) = &
     &            vzbath_cent(j,nnhc-inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,nnhc-inhc,l)*vzfact*dt_ys

            end do

!           /*   update the particle velocities   */

            pvxfact = exp(-0.5d0*vxbath_cent(j,1,l)*dt_ys)
            pvyfact = exp(-0.5d0*vybath_cent(j,1,l)*dt_ys)
            pvzfact = exp(-0.5d0*vzbath_cent(j,1,l)*dt_ys)

            scalex = scalex*pvxfact
            scaley = scaley*pvyfact
            scalez = scalez*pvzfact

!           /*   update the force   */

            fxbath_cent(j,1,l) &
     &         = (scalex*scalex*dkinx - gkt)/qmass_cent_multi_a(1,l)
            fybath_cent(j,1,l) &
     &         = (scaley*scaley*dkiny - gkt)/qmass_cent_multi_a(1,l)
            fzbath_cent(j,1,l) &
     &         = (scalez*scalez*dkinz - gkt)/qmass_cent_multi_a(1,l)

!           /*   update the thermostat positions   */
            do inhc = 1, nnhc
               xbath_cent(j,inhc,l) = xbath_cent(j,inhc,l) &
     &            + 0.5d0*vxbath_cent(j,inhc,l)*dt_ys
               ybath_cent(j,inhc,l) = ybath_cent(j,inhc,l) &
     &            + 0.5d0*vybath_cent(j,inhc,l)*dt_ys
               zbath_cent(j,inhc,l) = zbath_cent(j,inhc,l) &
     &            + 0.5d0*vzbath_cent(j,inhc,l)*dt_ys
            end do

!          /*   update the thermostat velocities   */

            do inhc = 1, nnhc-1

               vxfact = exp(-0.125d0*vxbath_cent(j,inhc+1,l)*dt_ys)
               vyfact = exp(-0.125d0*vybath_cent(j,inhc+1,l)*dt_ys)
               vzfact = exp(-0.125d0*vzbath_cent(j,inhc+1,l)*dt_ys)

               vxbath_cent(j,inhc,l) = &
     &            vxbath_cent(j,inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,inhc,l)*vxfact*dt_ys
               vybath_cent(j,inhc,l) = &
     &            vybath_cent(j,inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,inhc,l)*vyfact*dt_ys
               vzbath_cent(j,inhc,l) = &
     &            vzbath_cent(j,inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,inhc,l)*vzfact*dt_ys

               fxbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_a(inhc,l)*vxbath_cent(j,inhc,l) &
     &            *vxbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_a(inhc+1,l)
               fybath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_a(inhc,l)*vybath_cent(j,inhc,l) &
     &            *vybath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_a(inhc+1,l)
               fzbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_a(inhc,l)*vzbath_cent(j,inhc,l) &
     &            *vzbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_a(inhc+1,l)

            end do

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

!           /*   update the paricle velocities   */

            vux(j,1) = vux(j,1)*scalex
            vuy(j,1) = vuy(j,1)*scaley
            vuz(j,1) = vuz(j,1)*scalez

!-----------------------------------------------------------------------
!        /*   massive nhc end                                         */
!-----------------------------------------------------------------------

         end do
         end do

!-----------------------------------------------------------------------
!        /*   massive nhc start                                       */
!-----------------------------------------------------------------------

         do l = ncolor, 1, -1
         do j = natom, 1, -1

            if ( layer(j)(1:1) .ne. 'A' ) cycle

!           /*   calculate total kinetic energy of the system   */

            dkinx = fictmass(j,1)*vux(j,1)*vux(j,1)
            dkiny = fictmass(j,1)*vuy(j,1)*vuy(j,1)
            dkinz = fictmass(j,1)*vuz(j,1)*vuz(j,1)

            scalex = 1.d0
            scaley = 1.d0
            scalez = 1.d0

            fxbath_cent(j,1,l) = (dkinx - gkt)/qmass_cent_multi_a(1,l)
            fybath_cent(j,1,l) = (dkiny - gkt)/qmass_cent_multi_a(1,l)
            fzbath_cent(j,1,l) = (dkinz - gkt)/qmass_cent_multi_a(1,l)

            do i = 2, nnhc
              fxbath_cent(j,i,l) = &
     &           (qmass_cent_multi_a(i-1,l)*vxbath_cent(j,i-1,l) &
     &           *vxbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_a(i,l)
              fybath_cent(j,i,l) = &
     &           (qmass_cent_multi_a(i-1,l)*vybath_cent(j,i-1,l) &
     &           *vybath_cent(j,i-1,l) - gkt)/qmass_cent_multi_a(i,l)
              fzbath_cent(j,i,l) = &
     &           (qmass_cent_multi_a(i-1,l)*vzbath_cent(j,i-1,l) &
     &           *vzbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_a(i,l)
            end do

!           /*   update the thermostat velocities   */

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

            do inhc = 1, nnhc-1

               vxfact &
     &            = exp(-0.125d0*vxbath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vyfact &
     &            = exp(-0.125d0*vybath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vzfact &
     &            = exp(-0.125d0*vzbath_cent(j,nnhc-inhc+1,l)*dt_ys)

               vxbath_cent(j,nnhc-inhc,l) = &
     &            vxbath_cent(j,nnhc-inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,nnhc-inhc,l)*vxfact*dt_ys
               vybath_cent(j,nnhc-inhc,l) = &
     &            vybath_cent(j,nnhc-inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,nnhc-inhc,l)*vyfact*dt_ys
               vzbath_cent(j,nnhc-inhc,l) = &
     &            vzbath_cent(j,nnhc-inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,nnhc-inhc,l)*vzfact*dt_ys

            end do

!           /*   update the particle velocities   */

            pvxfact = exp(-0.5d0*vxbath_cent(j,1,l)*dt_ys)
            pvyfact = exp(-0.5d0*vybath_cent(j,1,l)*dt_ys)
            pvzfact = exp(-0.5d0*vzbath_cent(j,1,l)*dt_ys)

            scalex = scalex*pvxfact
            scaley = scaley*pvyfact
            scalez = scalez*pvzfact

!           /*   update the force   */

            fxbath_cent(j,1,l) &
     &         = (scalex*scalex*dkinx - gkt)/qmass_cent_multi_a(1,l)
            fybath_cent(j,1,l) &
     &         = (scaley*scaley*dkiny - gkt)/qmass_cent_multi_a(1,l)
            fzbath_cent(j,1,l) &
     &         = (scalez*scalez*dkinz - gkt)/qmass_cent_multi_a(1,l)

!           /*   update the thermostat positions   */
            do inhc = 1, nnhc
               xbath_cent(j,inhc,l) = xbath_cent(j,inhc,l) &
     &            + 0.5d0*vxbath_cent(j,inhc,l)*dt_ys
               ybath_cent(j,inhc,l) = ybath_cent(j,inhc,l) &
     &            + 0.5d0*vybath_cent(j,inhc,l)*dt_ys
               zbath_cent(j,inhc,l) = zbath_cent(j,inhc,l) &
     &            + 0.5d0*vzbath_cent(j,inhc,l)*dt_ys
            end do

!          /*   update the thermostat velocities   */

            do inhc = 1, nnhc-1

               vxfact = exp(-0.125d0*vxbath_cent(j,inhc+1,l)*dt_ys)
               vyfact = exp(-0.125d0*vybath_cent(j,inhc+1,l)*dt_ys)
               vzfact = exp(-0.125d0*vzbath_cent(j,inhc+1,l)*dt_ys)

               vxbath_cent(j,inhc,l) = &
     &            vxbath_cent(j,inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,inhc,l)*vxfact*dt_ys
               vybath_cent(j,inhc,l) = &
     &            vybath_cent(j,inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,inhc,l)*vyfact*dt_ys
               vzbath_cent(j,inhc,l) = &
     &            vzbath_cent(j,inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,inhc,l)*vzfact*dt_ys

               fxbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_a(inhc,l)*vxbath_cent(j,inhc,l) &
     &            *vxbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_a(inhc+1,l)
               fybath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_a(inhc,l)*vybath_cent(j,inhc,l) &
     &            *vybath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_a(inhc+1,l)
               fzbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_a(inhc,l)*vzbath_cent(j,inhc,l) &
     &            *vzbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_a(inhc+1,l)

            end do

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

!           /*   update the paricle velocities   */

            vux(j,1) = vux(j,1)*scalex
            vuy(j,1) = vuy(j,1)*scaley
            vuz(j,1) = vuz(j,1)*scalez

!-----------------------------------------------------------------------
!        /*   massive nhc end                                         */
!-----------------------------------------------------------------------

         end do
         end do

!-----------------------------------------------------------------------
!     /*   main loop end                                              */
!-----------------------------------------------------------------------

      end do

      return
      end





!***********************************************************************
      subroutine update_mnhc_cent_me_s ( ds )
!***********************************************************************
!=======================================================================
!
!     Update Nose-Hoover chain thermostat attached to centroid.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fictmass, vux, vuy, vuz, ysweight, fxbath_cent, fybath_cent, &
     &   fzbath_cent, vxbath_cent, vybath_cent, vzbath_cent, gkt, &
     &   xbath_cent, ybath_cent, zbath_cent, nys, nnhc, ncolor, natom

      use qmmm_variables, only : &
     &   qmass_cent_multi_b, layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, iys, inhc, l

      real(8) :: ds, dt_ys, dkinx, dkiny, dkinz, scalex, scaley, scalez, &
     &           vxfact, vyfact, vzfact, pvxfact, pvyfact, pvzfact

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do iys = 1, nys

!-----------------------------------------------------------------------
!        /*   step size                                               */
!-----------------------------------------------------------------------

         dt_ys = ds*ysweight(iys) /2.d0

!-----------------------------------------------------------------------
!        /*   massive nhc start                                       */
!-----------------------------------------------------------------------

         do l = 1, ncolor
         do j = 1, natom

            if ( layer(j)(1:1) .ne. 'B' ) cycle

!           /*   calculate total kinetic energy of the system   */

            dkinx = fictmass(j,1)*vux(j,1)*vux(j,1)
            dkiny = fictmass(j,1)*vuy(j,1)*vuy(j,1)
            dkinz = fictmass(j,1)*vuz(j,1)*vuz(j,1)

            scalex = 1.d0
            scaley = 1.d0
            scalez = 1.d0

            fxbath_cent(j,1,l) = (dkinx - gkt)/qmass_cent_multi_b(1,l)
            fybath_cent(j,1,l) = (dkiny - gkt)/qmass_cent_multi_b(1,l)
            fzbath_cent(j,1,l) = (dkinz - gkt)/qmass_cent_multi_b(1,l)

            do i = 2, nnhc
              fxbath_cent(j,i,l) = &
     &           (qmass_cent_multi_b(i-1,l)*vxbath_cent(j,i-1,l) &
     &           *vxbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_b(i,l)
              fybath_cent(j,i,l) = &
     &           (qmass_cent_multi_b(i-1,l)*vybath_cent(j,i-1,l) &
     &           *vybath_cent(j,i-1,l) - gkt)/qmass_cent_multi_b(i,l)
              fzbath_cent(j,i,l) = &
     &           (qmass_cent_multi_b(i-1,l)*vzbath_cent(j,i-1,l) &
     &           *vzbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_b(i,l)
            end do

!           /*   update the thermostat velocities   */

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

            do inhc = 1, nnhc-1

               vxfact &
     &            = exp(-0.125d0*vxbath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vyfact &
     &            = exp(-0.125d0*vybath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vzfact &
     &            = exp(-0.125d0*vzbath_cent(j,nnhc-inhc+1,l)*dt_ys)

               vxbath_cent(j,nnhc-inhc,l) = &
     &            vxbath_cent(j,nnhc-inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,nnhc-inhc,l)*vxfact*dt_ys
               vybath_cent(j,nnhc-inhc,l) = &
     &            vybath_cent(j,nnhc-inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,nnhc-inhc,l)*vyfact*dt_ys
               vzbath_cent(j,nnhc-inhc,l) = &
     &            vzbath_cent(j,nnhc-inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,nnhc-inhc,l)*vzfact*dt_ys

            end do

!           /*   update the particle velocities   */

            pvxfact = exp(-0.5d0*vxbath_cent(j,1,l)*dt_ys)
            pvyfact = exp(-0.5d0*vybath_cent(j,1,l)*dt_ys)
            pvzfact = exp(-0.5d0*vzbath_cent(j,1,l)*dt_ys)

            scalex = scalex*pvxfact
            scaley = scaley*pvyfact
            scalez = scalez*pvzfact

!           /*   update the force   */

            fxbath_cent(j,1,l) &
     &         = (scalex*scalex*dkinx - gkt)/qmass_cent_multi_b(1,l)
            fybath_cent(j,1,l) &
     &         = (scaley*scaley*dkiny - gkt)/qmass_cent_multi_b(1,l)
            fzbath_cent(j,1,l) &
     &         = (scalez*scalez*dkinz - gkt)/qmass_cent_multi_b(1,l)

!           /*   update the thermostat positions   */
            do inhc = 1, nnhc
               xbath_cent(j,inhc,l) = xbath_cent(j,inhc,l) &
     &            + 0.5d0*vxbath_cent(j,inhc,l)*dt_ys
               ybath_cent(j,inhc,l) = ybath_cent(j,inhc,l) &
     &            + 0.5d0*vybath_cent(j,inhc,l)*dt_ys
               zbath_cent(j,inhc,l) = zbath_cent(j,inhc,l) &
     &            + 0.5d0*vzbath_cent(j,inhc,l)*dt_ys
            end do

!          /*   update the thermostat velocities   */

            do inhc = 1, nnhc-1

               vxfact = exp(-0.125d0*vxbath_cent(j,inhc+1,l)*dt_ys)
               vyfact = exp(-0.125d0*vybath_cent(j,inhc+1,l)*dt_ys)
               vzfact = exp(-0.125d0*vzbath_cent(j,inhc+1,l)*dt_ys)

               vxbath_cent(j,inhc,l) = &
     &            vxbath_cent(j,inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,inhc,l)*vxfact*dt_ys
               vybath_cent(j,inhc,l) = &
     &            vybath_cent(j,inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,inhc,l)*vyfact*dt_ys
               vzbath_cent(j,inhc,l) = &
     &            vzbath_cent(j,inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,inhc,l)*vzfact*dt_ys

               fxbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_b(inhc,l)*vxbath_cent(j,inhc,l) &
     &            *vxbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_b(inhc+1,l)
               fybath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_b(inhc,l)*vybath_cent(j,inhc,l) &
     &            *vybath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_b(inhc+1,l)
               fzbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_b(inhc,l)*vzbath_cent(j,inhc,l) &
     &            *vzbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_b(inhc+1,l)

            end do

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

!           /*   update the paricle velocities   */

            vux(j,1) = vux(j,1)*scalex
            vuy(j,1) = vuy(j,1)*scaley
            vuz(j,1) = vuz(j,1)*scalez

!-----------------------------------------------------------------------
!        /*   massive nhc end                                         */
!-----------------------------------------------------------------------

         end do
         end do

!-----------------------------------------------------------------------
!        /*   massive nhc start                                       */
!-----------------------------------------------------------------------

         do l = ncolor, 1, -1
         do j = natom, 1, -1

            if ( layer(j)(1:1) .ne. 'B' ) cycle

!           /*   calculate total kinetic energy of the system   */

            dkinx = fictmass(j,1)*vux(j,1)*vux(j,1)
            dkiny = fictmass(j,1)*vuy(j,1)*vuy(j,1)
            dkinz = fictmass(j,1)*vuz(j,1)*vuz(j,1)

            scalex = 1.d0
            scaley = 1.d0
            scalez = 1.d0

            fxbath_cent(j,1,l) = (dkinx - gkt)/qmass_cent_multi_b(1,l)
            fybath_cent(j,1,l) = (dkiny - gkt)/qmass_cent_multi_b(1,l)
            fzbath_cent(j,1,l) = (dkinz - gkt)/qmass_cent_multi_b(1,l)

            do i = 2, nnhc
              fxbath_cent(j,i,l) = &
     &           (qmass_cent_multi_b(i-1,l)*vxbath_cent(j,i-1,l) &
     &           *vxbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_b(i,l)
              fybath_cent(j,i,l) = &
     &           (qmass_cent_multi_b(i-1,l)*vybath_cent(j,i-1,l) &
     &           *vybath_cent(j,i-1,l) - gkt)/qmass_cent_multi_b(i,l)
              fzbath_cent(j,i,l) = &
     &           (qmass_cent_multi_b(i-1,l)*vzbath_cent(j,i-1,l) &
     &           *vzbath_cent(j,i-1,l) - gkt)/qmass_cent_multi_b(i,l)
            end do

!           /*   update the thermostat velocities   */

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

            do inhc = 1, nnhc-1

               vxfact &
     &            = exp(-0.125d0*vxbath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vyfact &
     &            = exp(-0.125d0*vybath_cent(j,nnhc-inhc+1,l)*dt_ys)
               vzfact &
     &            = exp(-0.125d0*vzbath_cent(j,nnhc-inhc+1,l)*dt_ys)

               vxbath_cent(j,nnhc-inhc,l) = &
     &            vxbath_cent(j,nnhc-inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,nnhc-inhc,l)*vxfact*dt_ys
               vybath_cent(j,nnhc-inhc,l) = &
     &            vybath_cent(j,nnhc-inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,nnhc-inhc,l)*vyfact*dt_ys
               vzbath_cent(j,nnhc-inhc,l) = &
     &            vzbath_cent(j,nnhc-inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,nnhc-inhc,l)*vzfact*dt_ys

            end do

!           /*   update the particle velocities   */

            pvxfact = exp(-0.5d0*vxbath_cent(j,1,l)*dt_ys)
            pvyfact = exp(-0.5d0*vybath_cent(j,1,l)*dt_ys)
            pvzfact = exp(-0.5d0*vzbath_cent(j,1,l)*dt_ys)

            scalex = scalex*pvxfact
            scaley = scaley*pvyfact
            scalez = scalez*pvzfact

!           /*   update the force   */

            fxbath_cent(j,1,l) &
     &         = (scalex*scalex*dkinx - gkt)/qmass_cent_multi_b(1,l)
            fybath_cent(j,1,l) &
     &         = (scaley*scaley*dkiny - gkt)/qmass_cent_multi_b(1,l)
            fzbath_cent(j,1,l) &
     &         = (scalez*scalez*dkinz - gkt)/qmass_cent_multi_b(1,l)

!           /*   update the thermostat positions   */
            do inhc = 1, nnhc
               xbath_cent(j,inhc,l) = xbath_cent(j,inhc,l) &
     &            + 0.5d0*vxbath_cent(j,inhc,l)*dt_ys
               ybath_cent(j,inhc,l) = ybath_cent(j,inhc,l) &
     &            + 0.5d0*vybath_cent(j,inhc,l)*dt_ys
               zbath_cent(j,inhc,l) = zbath_cent(j,inhc,l) &
     &            + 0.5d0*vzbath_cent(j,inhc,l)*dt_ys
            end do

!          /*   update the thermostat velocities   */

            do inhc = 1, nnhc-1

               vxfact = exp(-0.125d0*vxbath_cent(j,inhc+1,l)*dt_ys)
               vyfact = exp(-0.125d0*vybath_cent(j,inhc+1,l)*dt_ys)
               vzfact = exp(-0.125d0*vzbath_cent(j,inhc+1,l)*dt_ys)

               vxbath_cent(j,inhc,l) = &
     &            vxbath_cent(j,inhc,l)*vxfact*vxfact &
     &            + 0.25d0*fxbath_cent(j,inhc,l)*vxfact*dt_ys
               vybath_cent(j,inhc,l) = &
     &            vybath_cent(j,inhc,l)*vyfact*vyfact &
     &            + 0.25d0*fybath_cent(j,inhc,l)*vyfact*dt_ys
               vzbath_cent(j,inhc,l) = &
     &            vzbath_cent(j,inhc,l)*vzfact*vzfact &
     &            + 0.25d0*fzbath_cent(j,inhc,l)*vzfact*dt_ys

               fxbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_b(inhc,l)*vxbath_cent(j,inhc,l) &
     &            *vxbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_b(inhc+1,l)
               fybath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_b(inhc,l)*vybath_cent(j,inhc,l) &
     &            *vybath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_b(inhc+1,l)
               fzbath_cent(j,inhc+1,l) = &
     &            (qmass_cent_multi_b(inhc,l)*vzbath_cent(j,inhc,l) &
     &            *vzbath_cent(j,inhc,l) - gkt) &
     &            /qmass_cent_multi_b(inhc+1,l)

            end do

            vxbath_cent(j,nnhc,l) = vxbath_cent(j,nnhc,l) &
     &         + 0.25d0*fxbath_cent(j,nnhc,l)*dt_ys
            vybath_cent(j,nnhc,l) = vybath_cent(j,nnhc,l) &
     &         + 0.25d0*fybath_cent(j,nnhc,l)*dt_ys
            vzbath_cent(j,nnhc,l) = vzbath_cent(j,nnhc,l) &
     &         + 0.25d0*fzbath_cent(j,nnhc,l)*dt_ys

!           /*   update the paricle velocities   */

            vux(j,1) = vux(j,1)*scalex
            vuy(j,1) = vuy(j,1)*scaley
            vuz(j,1) = vuz(j,1)*scalez

!-----------------------------------------------------------------------
!        /*   massive nhc end                                         */
!-----------------------------------------------------------------------

         end do
         end do

!-----------------------------------------------------------------------
!     /*   main loop end                                              */
!-----------------------------------------------------------------------

      end do

      return
      end
