!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     cv updates in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_cv_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead

      use tass_variables, only : &
     &   rtass, vtass, dt_ref_tass, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, ntass
         rtass(i,j) = rtass(i,j) + vtass(i,j)*dt_ref_tass
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_cv_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead

      use tass_variables, only : &
     &   vtass, ftass, fictmass_tass, dt_ref_tass, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, ntass
         vtass(i,j) = vtass(i,j) &
     &              + 0.5d0*ftass(i,j)/fictmass_tass(i)*dt_ref_tass
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_cv_ref_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead

      use tass_variables, only : &
     &   vtass, fref_tass, fictmass_tass, dt_ref_tass, ntass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, ntass
         vtass(i,j) = vtass(i,j) &
     &              + 0.5d0*fref_tass(i,j)/fictmass_tass(i)*dt_ref_tass
      end do
      end do

      return
      end
