!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     cv updates in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_pos_cv_meta
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead

      use meta_variables, only : &
     &   rmeta, vmeta, dt_ref_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, nmeta
         rmeta(i,j) = rmeta(i,j) + vmeta(i,j)*dt_ref_meta
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_cv_meta
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead

      use meta_variables, only : &
     &   vmeta, fmeta, fictmass_meta, dt_ref_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, nmeta
         vmeta(i,j) = vmeta(i,j) &
     &              + 0.5d0*fmeta(i,j)/fictmass_meta(i)*dt_ref_meta
      end do
      end do

      return
      end





!***********************************************************************
      subroutine update_vel_cv_ref_meta
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead

      use meta_variables, only : &
     &   vmeta, fref_meta, fictmass_meta, dt_ref_meta, nmeta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, nmeta
         vmeta(i,j) = vmeta(i,j) &
     &              + 0.5d0*fref_meta(i,j)/fictmass_meta(i)*dt_ref_meta
      end do
      end do

      return
      end
