!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     update coefficients of wavefunction
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine update_cstate
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vx, vy, vz, dt_ref, hbar, nref, nbead, natom, iref

      use common_variables, only : &
     &   zin

      use multistate_variables, only : &
     &   cstate, vstate, dxstate, dystate, dzstate, nstate

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l

      complex(8), dimension(nstate,nstate) :: a
      complex(8), dimension(nstate,nstate) :: b
      complex(8), dimension(nstate)        :: e
      complex(8)                           :: c

!-----------------------------------------------------------------------
!     /*   update state coefficients                                  */
!-----------------------------------------------------------------------

!     /*   time step of inner loop:  0.5*dt_ref = 0.5*dt/nref   */

      do iref = 1, nref

         do l = 1, nbead

!           /*   matrix a   */

            do j = 1, nstate
            do i = 1, nstate

               a(i,j) = dcmplx( vstate(i,j,l), 0.d0 ) / (zin*hbar)

               do k = 1, natom

                  a(i,j) = a(i,j) &
     &                   - dcmplx( dxstate(i,j,k,l)*vx(k,l), 0.d0 ) &
     &                   - dcmplx( dystate(i,j,k,l)*vy(k,l), 0.d0 ) &
     &                   - dcmplx( dzstate(i,j,k,l)*vz(k,l), 0.d0 )

               end do

            end do
            end do

!           /*   diagonalize matrix a   */

            call zdiag ( a, e, b, nstate )

!           /*   c(dt) = exp(a*dt) c(0) = b' exp(e*dt) b c(0)   */

            do j = 1, nstate
            do i = 1, nstate
               c = 0.d0
               do k = 1, nstate
                  c = c + b(i,k)*exp(e(k)*0.5d0*dt_ref)*dconjg(b(j,k))
               end do
               a(i,j) = c
            end do
            end do

            do i = 1, nstate
               c = 0.d0
               do j = 1, nstate
                  c = c + a(i,j)*cstate(j,l)
               end do
               e(i) = c
            end do

            do i = 1, nstate
               cstate(i,l) = e(i)
            end do

         end do

      end do

      return
      end
